/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.android.media.audio;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioDeviceInfo;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.Window;
import com.voxeet.android.media.audio.AudioRoute;
import com.voxeet.android.media.audio.IMediaStateListener;
import com.voxeet.android.media.audio.focus.AudioFocusManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eventbus.EventBus;
import voxeet.com.sdk.events.AudioRouteChangeEvent;
import voxeet.com.sdk.utils.Validate;

public class AudioManager {
    private static final String TAG = AudioManager.class.getSimpleName();
    private Context mContext;
    private boolean isBluetoothScoStarted;
    private Handler handler = new Handler();
    private static final int MODE_IN_COMMUNICATION = 3;
    private static final int MODE_CURRENT = -1;
    private static final int STREAM_VOICE_CALL = 0;
    private static final int STREAM_BLUETOOTH_SCO = 6;
    private static final int STREAM_SYSTEM = 1;
    private static final int STREAM_MUSIC = 3;
    private android.media.AudioManager mServiceAudioManager;
    private HeadsetStateReceiver mHeadsetStateReceiver;
    private BluetoothHeadset mCurrentBluetoothHeadset;
    private BluetoothHeadsetListener mBluetoothHeadsetListener;
    private BluetoothAdapter mBluetoothAdapter;
    private AudioRoute mOutputRoute = AudioRoute.ROUTE_PHONE;
    private List<IMediaStateListener> mMediaStateListeners;
    private int mSoundType;
    private AudioFocusManager manager;
    private Runnable runnableBluetoothSco = new Runnable(){

        @Override
        public void run() {
            AudioManager.this.requestAudioFocus();
            try {
                AudioManager.this.mServiceAudioManager.startBluetoothSco();
                AudioManager.this.mServiceAudioManager.setBluetoothScoOn(true);
                AudioManager.this.isBluetoothScoStarted = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                AudioManager.this.isBluetoothScoStarted = false;
            }
        }
    };

    public void requestAudioFocus() {
        Log.d((String)TAG, (String)"requestAudioFocus: ");
        this.manager.requestAudioFocus(this.mServiceAudioManager);
    }

    public void abandonAudioFocusRequest() {
        Log.d((String)TAG, (String)"abandonAudioFocusRequest: ");
        this.forceVolumeControlStream(3);
        this.manager.abandonAudioFocus(this.mServiceAudioManager);
    }

    private AudioManager() {
    }

    public AudioManager(Context context) {
        this();
        this.manager = new AudioFocusManager();
        this.mContext = context;
        this.mMediaStateListeners = new ArrayList<IMediaStateListener>();
        this.mHeadsetStateReceiver = new HeadsetStateReceiver();
        this.mBluetoothHeadsetListener = new BluetoothHeadsetListener();
        this.mCurrentBluetoothHeadset = null;
        this.isBluetoothScoStarted = false;
        this.mServiceAudioManager = (android.media.AudioManager)context.getSystemService("audio");
        this.checkForBluetoothDeviceAtStartUp();
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.mBluetoothAdapter != null) {
            try {
                this.mBluetoothAdapter.getProfileProxy(context, (BluetoothProfile.ServiceListener)this.mBluetoothHeadsetListener, 1);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
        this.mSoundType = this.getUiSoundsStreamType();
        context.registerReceiver((BroadcastReceiver)this.mHeadsetStateReceiver, new IntentFilter("android.intent.action.HEADSET_PLUG"));
        context.registerReceiver((BroadcastReceiver)this.mHeadsetStateReceiver, new IntentFilter("android.bluetooth.device.action.ACL_CONNECTED"));
        context.registerReceiver((BroadcastReceiver)this.mHeadsetStateReceiver, new IntentFilter("android.bluetooth.device.action.ACL_DISCONNECTED"));
        context.registerReceiver((BroadcastReceiver)this.mHeadsetStateReceiver, new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED"));
        context.registerReceiver((BroadcastReceiver)this.mHeadsetStateReceiver, new IntentFilter("android.media.SCO_AUDIO_STATE_CHANGED"));
    }

    public void stop() {
        this.setBluetooth(false);
        this.mContext.unregisterReceiver((BroadcastReceiver)this.mHeadsetStateReceiver);
        if (this.mCurrentBluetoothHeadset != null && this.mBluetoothAdapter != null) {
            this.mBluetoothAdapter.closeProfileProxy(1, (BluetoothProfile)this.mCurrentBluetoothHeadset);
        }
    }

    @NonNull
    public List<AudioRoute> availableRoutes() {
        ArrayList<AudioRoute> routes = new ArrayList<AudioRoute>();
        routes.add(AudioRoute.ROUTE_SPEAKER);
        if (this.isWiredHeadsetOn()) {
            routes.add(AudioRoute.ROUTE_HEADSET);
        } else {
            routes.add(AudioRoute.ROUTE_PHONE);
        }
        if (this.isBluetoothHeadsetConnected()) {
            routes.add(AudioRoute.ROUTE_BLUETOOTH);
        }
        return routes;
    }

    @NonNull
    public AudioRoute outputRoute() {
        return this.mOutputRoute;
    }

    public boolean setOutputRoute(@NonNull AudioRoute route) {
        if (null == route) {
            return false;
        }
        switch (route) {
            case ROUTE_BLUETOOTH: {
                if (!this.isBluetoothHeadsetConnected()) break;
                this.setBluetooth(true);
                break;
            }
            case ROUTE_HEADSET: 
            case ROUTE_PHONE: {
                this.setSpeakerMode(false);
                break;
            }
            case ROUTE_SPEAKER: {
                if (this.isWiredHeadsetOn() || this.isBluetoothHeadsetConnected()) {
                    return false;
                }
                this.setSpeakerMode(true);
                break;
            }
        }
        EventBus.getDefault().post((Object)new AudioRouteChangeEvent());
        return true;
    }

    public void setVolumeControlStream(Window window, int streamType) {
        window.setVolumeControlStream(streamType);
    }

    public void setSpeakerMode(boolean speakerMode) {
        if (speakerMode) {
            this.setBluetooth(false);
        }
        if (this.isBluetoothHeadsetConnected()) {
            this.mServiceAudioManager.setSpeakerphoneOn(false);
            this.mServiceAudioManager.setMode(3);
            this.forceVolumeControlStream(6);
        } else if ("samsung".equalsIgnoreCase(Build.BRAND)) {
            if (speakerMode) {
                this.mServiceAudioManager.setSpeakerphoneOn(true);
                this.mServiceAudioManager.setMode(-1);
            } else {
                this.mServiceAudioManager.setSpeakerphoneOn(speakerMode);
                if (this.mServiceAudioManager.isWiredHeadsetOn()) {
                    this.mServiceAudioManager.setMode(-1);
                } else {
                    this.mServiceAudioManager.setMode(3);
                }
            }
            this.forceVolumeControlStream(0);
        } else {
            this.mServiceAudioManager.setMode(3);
            this.mServiceAudioManager.setSpeakerphoneOn(speakerMode);
            this.forceVolumeControlStream(0);
        }
        for (IMediaStateListener listeners : this.mMediaStateListeners) {
            try {
                listeners.onSpeakerChanged(speakerMode);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.checkOutputRoute();
    }

    public void setBluetooth(boolean isEnabled) {
        this.forceVolumeControlStream(0);
        this.checkOutputRoute();
        try {
            if (isEnabled) {
                this.startBluetoothSco();
            } else {
                this.stopBluetoothSco();
            }
        }
        catch (NullPointerException e) {
            Log.d((String)TAG, (String)"No bluetooth headset connected");
        }
    }

    public void registerMediaState(@NonNull IMediaStateListener listener) {
        if (!this.mMediaStateListeners.contains(listener)) {
            this.mMediaStateListeners.add(listener);
        }
    }

    public void unregisterMediaState(@NonNull IMediaStateListener listener) {
        this.mMediaStateListeners.remove(listener);
    }

    public int getDefaultSoundStreamType() {
        return this.mSoundType;
    }

    public void resetDefaultSoundType() {
        if (this.mSoundType >= 0) {
            this.forceVolumeControlStream(this.mSoundType);
        }
    }

    public void forceVolumeControlStream(int type) {
        Log.d((String)TAG, (String)("forceVolumeControlStream: " + type));
        try {
            Method method = this.mServiceAudioManager.getClass().getDeclaredMethod("forceVolumeControlStream", Integer.TYPE);
            method.invoke((Object)this.mServiceAudioManager, type);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public boolean isBluetoothHeadsetConnected() {
        this.checkForBluetoothDeviceAtStartUp();
        return this.isBluetoothScoStarted;
    }

    public boolean isWiredHeadsetOn() {
        if (Build.VERSION.SDK_INT >= 23) {
            AudioDeviceInfo[] audioDevices;
            for (AudioDeviceInfo deviceInfo : audioDevices = this.mServiceAudioManager.getDevices(3)) {
                if (deviceInfo.getType() != 4 && deviceInfo.getType() != 3) continue;
                return true;
            }
        }
        return this.mServiceAudioManager.isWiredHeadsetOn();
    }

    public boolean isHeadphonesPlugged() {
        return this.isWiredHeadsetOn() || this.isBluetoothHeadsetConnected();
    }

    private void checkOutputRoute() {
        this.mOutputRoute = this.isBluetoothScoStarted ? AudioRoute.ROUTE_BLUETOOTH : (null != this.mServiceAudioManager && this.mServiceAudioManager.isSpeakerphoneOn() ? AudioRoute.ROUTE_SPEAKER : (null != this.mServiceAudioManager && this.mServiceAudioManager.isWiredHeadsetOn() ? AudioRoute.ROUTE_HEADSET : AudioRoute.ROUTE_PHONE));
        this.requestAudioFocus();
    }

    private int getUiSoundsStreamType() {
        try {
            Method method = this.mServiceAudioManager.getClass().getDeclaredMethod("getUiSoundsStreamType", new Class[0]);
            Object result = method.invoke((Object)this.mServiceAudioManager, new Object[0]);
            return (Integer)result;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return 1;
    }

    private void checkForBluetoothDeviceAtStartUp() {
        Log.d((String)TAG, (String)"checkForBluetoothDeviceAtStartUp");
        try {
            if (Build.VERSION.SDK_INT >= 23) {
                AudioDeviceInfo[] audioDevices;
                for (AudioDeviceInfo deviceInfo : audioDevices = this.mServiceAudioManager.getDevices(3)) {
                    Log.d((String)TAG, (String)("checkForBluetoothDeviceAtStartUp: " + deviceInfo.getProductName() + " " + deviceInfo.isSource() + " " + deviceInfo.isSink()));
                    if (deviceInfo.getType() != 7) continue;
                    this.isBluetoothScoStarted = true;
                }
            } else {
                BluetoothAdapter mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
                if (mBluetoothAdapter != null && mBluetoothAdapter.isEnabled() && mBluetoothAdapter.getProfileConnectionState(1) == 2) {
                    this.isBluetoothScoStarted = true;
                }
            }
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"checkForBluetoothDeviceAtStartUp: exception thrown, have you the BLUETOOTH permission?");
            e.printStackTrace();
        }
    }

    private void startBluetoothSco() {
        this.handler.postDelayed(this.runnableBluetoothSco, 3000L);
    }

    private void stopBluetoothSco() {
        this.handler.removeCallbacks(this.runnableBluetoothSco);
        if (this.isBluetoothScoStarted) {
            try {
                this.mServiceAudioManager.setBluetoothScoOn(false);
                this.mServiceAudioManager.stopBluetoothSco();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.isBluetoothScoStarted = false;
        }
    }

    private void updateBluetoothHeadsetConnectivity(@Nullable BluetoothDevice device) {
        Log.d((String)TAG, (String)("updateBluetoothHeadsetConnectivity: " + device));
        if (null != this.mCurrentBluetoothHeadset) {
            if (Validate.hasBluetoothPermissions(this.mContext)) {
                this.isBluetoothScoStarted = this.mCurrentBluetoothHeadset.getConnectedDevices().size() > 0;
                this.isBluetoothScoStarted |= null != device;
            } else {
                Log.e((String)TAG, (String)"onServiceConnected: BLUETOOTH PERMISSION MISSING");
            }
            for (IMediaStateListener listeners : this.mMediaStateListeners) {
                listeners.onBluetoothHeadsetStateChange(this.isBluetoothScoStarted);
            }
            Log.d((String)TAG, (String)("onServiceConnected: isBluetoothScoStarted = " + this.isBluetoothScoStarted));
            this.startBluetoothSco();
            this.checkOutputRoute();
            EventBus.getDefault().post((Object)new AudioRouteChangeEvent());
        }
    }

    private class HeadsetStateReceiver
    extends BroadcastReceiver {
        private HeadsetStateReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            Log.d((String)TAG, (String)("onReceive: " + intent.getAction()));
            String action = intent.getAction();
            if (null == action) {
                action = "";
            }
            block6 : switch (action) {
                case "android.intent.action.HEADSET_PLUG": {
                    boolean isPlugged;
                    int state = intent.getIntExtra("state", -1);
                    int has_mic = intent.getIntExtra("microphone", -1);
                    boolean bl = isPlugged = state == 1 && has_mic == 1;
                    if (isPlugged) {
                        for (IMediaStateListener listeners : AudioManager.this.mMediaStateListeners) {
                            listeners.onHeadsetStateChange(true);
                        }
                        AudioManager.this.setSpeakerMode(false);
                        AudioManager.this.checkOutputRoute();
                        EventBus.getDefault().post((Object)new AudioRouteChangeEvent());
                        break;
                    }
                    for (IMediaStateListener listeners : AudioManager.this.mMediaStateListeners) {
                        listeners.onHeadsetStateChange(false);
                    }
                    AudioManager.this.checkOutputRoute();
                    EventBus.getDefault().post((Object)new AudioRouteChangeEvent());
                    break;
                }
                case "android.bluetooth.device.action.ACL_CONNECTED": {
                    BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    AudioManager.this.updateBluetoothHeadsetConnectivity(device);
                    break;
                }
                case "android.bluetooth.device.action.ACL_DISCONNECTED": {
                    AudioManager.this.updateBluetoothHeadsetConnectivity(null);
                    break;
                }
                case "android.media.SCO_AUDIO_STATE_CHANGED": {
                    int l_state = intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", -1);
                    Log.d((String)TAG, (String)"Audio SCO: android.media.SCO_AUDIO_STATE_CHANGED");
                    switch (l_state) {
                        case 1: {
                            Log.i((String)TAG, (String)"SCO_AUDIO_STATE_CONNECTED");
                            AudioManager.this.requestAudioFocus();
                            break block6;
                        }
                        case 0: {
                            Log.e((String)TAG, (String)"SCO_AUDIO_STATE_DISCONNECTED");
                            AudioManager.this.requestAudioFocus();
                            break block6;
                        }
                    }
                    Log.e((String)TAG, (String)("unknown state received:" + l_state));
                }
            }
        }
    }

    private class BluetoothHeadsetListener
    implements BluetoothProfile.ServiceListener {
        private BluetoothHeadsetListener() {
        }

        public void onServiceConnected(int i, BluetoothProfile bluetoothProfile) {
            if (bluetoothProfile instanceof BluetoothHeadset) {
                AudioManager.this.mCurrentBluetoothHeadset = (BluetoothHeadset)bluetoothProfile;
            }
            AudioManager.this.updateBluetoothHeadsetConnectivity(null);
        }

        public void onServiceDisconnected(int i) {
            AudioManager.this.mCurrentBluetoothHeadset = null;
            AudioManager.this.isBluetoothScoStarted = false;
            Log.d((String)TAG, (String)"onServiceDisconnected: isBluetoothScoStarted = true");
            for (IMediaStateListener listeners : AudioManager.this.mMediaStateListeners) {
                try {
                    listeners.onBluetoothHeadsetStateChange(false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            AudioManager.this.mServiceAudioManager.stopBluetoothSco();
            AudioManager.this.checkOutputRoute();
            EventBus.getDefault().post((Object)new AudioRouteChangeEvent());
        }
    }
}

