package voxeet.com.sdk.utils;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.Log;

import java.io.PrintWriter;
import java.io.StringWriter;

public class Twig {

    /*@Retention(RetentionPolicy.CLASS)
    @IntDef({Twig.LogLevel.VERBOSE, Twig.LogLevel.DEBUG, Twig.LogLevel.INFO, Twig.LogLevel.WARN,
            Twig.LogLevel.ERROR, Twig.LogLevel.ASSERT, Twig.LogLevel.DISABLED})
    @interface LogLevel {
        int VERBOSE = Log.VERBOSE;
        int DEBUG = Log.DEBUG;
        int INFO = Log.INFO;
        int WARN = Log.WARN;
        int ERROR = Log.ERROR;
        int ASSERT = Log.ASSERT;
        int DISABLED = Twig.DISABLED;
    }*/

    //private static final int MAX_LOG_LENGTH = 4000;

    @NonNull
    private final String tag;

    private int logLevel;

    private final boolean internalLoggingEnabled;

    public static final int DISABLED = 8;

    public Twig(int logLevel, @Nullable String tag, boolean internalLoggingEnabled) {
        this.logLevel = logLevel;
        this.tag = tag != null ? tag : "Twig";
        this.internalLoggingEnabled = internalLoggingEnabled;
    }

    public void v(String message, Object... args) {
        this.prepareLog(2, null, message, args);
    }

    public void v(Throwable t, String message, Object... args) {
        this.prepareLog(2, t, message, args);
    }

    public void v(Throwable t) {
        this.prepareLog(2, t, null, new Object[0]);
    }

    public void d(String message, Object... args) {
        this.prepareLog(3, null, message, args);
    }

    public void d(Throwable t, String message, Object... args) {
        this.prepareLog(3, t, message, args);
    }

    public void d(Throwable t) {
        this.prepareLog(3, t, null, new Object[0]);
    }

    public void i(String message, Object... args) {
        this.prepareLog(4, null, message, args);
    }

    public void i(Throwable t, String message, Object... args) {
        this.prepareLog(4, t, message, args);
    }

    public void i(Throwable t) {
        this.prepareLog(4, t, null, new Object[0]);
    }

    public void w(String message, Object... args) {
        this.prepareLog(5, null, message, args);
    }

    public void w(Throwable t, String message, Object... args) {
        this.prepareLog(5, t, message, args);
    }

    public void w(Throwable t) {
        this.prepareLog(5, t, null, new Object[0]);
    }

    public void e(String message, Object... args) {
        this.prepareLog(6, null, message, args);
    }

    public void e(Throwable t, String message, Object... args) {
        this.prepareLog(6, t, message, args);
    }

    public void e(Throwable t) {
        this.prepareLog(6, t, null, new Object[0]);
    }

    public void wtf(String message, Object... args) {
        this.prepareLog(7, null, message, args);
    }

    public void wtf(Throwable t, String message, Object... args) {
        this.prepareLog(7, t, message, args);
    }

    public void wtf(Throwable t) {
        this.prepareLog(7, t, null, new Object[0]);
    }

    public void internal(String text) {
        this.internal(this.tag, text);
    }

    public void internal(String tag, String text) {
        if (this.internalLoggingEnabled) {
            Log.d(tag, "INTERNAL: " + text);
        }
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    @VisibleForTesting
    int getLogLevel() {
        return this.logLevel;
    }

    public String getTag() {
        return this.tag;
    }

    private void prepareLog(int priority, @Nullable Throwable t, String message, Object... args) {
        if (priority >= this.logLevel) {
            String tag = this.getTag();
            if (message != null && message.length() == 0)
                message = null;

            if (message == null) {
                if (t == null)
                    return;

                message = this.getStackTraceString(t);
            } else {
                if (args.length > 0)
                    message = String.format(message, args);

                if (t != null)
                    message = message + "\n" + this.getStackTraceString(t);
            }

            this.log(priority, tag, message);
        }
    }

    @VisibleForTesting
    void log(int priority, String message, Object... args) {
        this.prepareLog(priority, null, message, args);
    }

    private void log(int priority, String tag, String message) {
        if (message.length() < 4000) {
            this.printLog(priority, tag, message);
        } else {
            int i = 0;

            int end;
            for (int length = message.length(); i < length; i = end + 1) {
                int newline = message.indexOf(10, i);
                newline = newline != -1 ? newline : length;

                do {
                    end = Math.min(newline, i + 4000);
                    String part = message.substring(i, end);
                    this.printLog(priority, tag, part);
                    i = end;
                } while (end < newline);
            }
        }
    }

    private void printLog(int priority, String tag, String message) {
        if (priority == 7) {
            Log.wtf(tag, message);
        } else {
            Log.println(priority, tag, message);
        }
    }

    private String getStackTraceString(Throwable t) {
        StringWriter sw = new StringWriter(256);
        PrintWriter pw = new PrintWriter(sw, false);
        t.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }
}