package voxeet.com.sdk.core.abs.information;

import android.support.annotation.NonNull;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import voxeet.com.sdk.core.ConferenceSimpleState;
import voxeet.com.sdk.models.impl.DefaultConference;
import voxeet.com.sdk.models.impl.DefaultConferenceUser;

/**
 * Created by kevinleperf on 29/08/2018.
 */

public class ConferenceInformation {

    @NonNull
    private DefaultConference mConference;

    @NonNull
    private String mConferenceId;

    @NonNull
    private Map<String, String> mUserIdsCached;

    private ConferenceSimpleState mConferenceType;

    @NonNull
    private List<DefaultConferenceUser> mLastInvitationReceived;
    private ConferenceState state = ConferenceState.DEFAULT;

    private boolean mOwnVideoStarted;

    private ConferenceInformation() {
        mConferenceId = "unknown";
        mUserIdsCached = new HashMap<>();
        mLastInvitationReceived = new ArrayList<>();
        mConference = new DefaultConference();
        mConferenceType = ConferenceSimpleState.NONE;
        mOwnVideoStarted = false;
    }

    public ConferenceInformation(@NonNull String conferenceId) {
        this();

        mConferenceId = conferenceId;
        mConference.setConferenceId(mConferenceId);
    }

    @NonNull
    public DefaultConference getConference() {
        return mConference;
    }

    public void setConference(@NonNull DefaultConference conference) {
        mConference = conference;
    }

    public void setConferenceType(@NonNull ConferenceSimpleState type) {
        mConferenceType = type;
    }

    @NonNull
    public ConferenceSimpleState getConferenceType() {
        return mConferenceType;
    }

    @NonNull
    public Map<String, String> getUserIdsCached() {
        return mUserIdsCached;
    }

    @NonNull
    public List<DefaultConferenceUser> getLastInvitationReceived() {
        return mLastInvitationReceived;
    }

    public void setConferenceState(@NonNull ConferenceState state) {
        this.state = state;
    }

    @NonNull
    public ConferenceState getState() {
        return state;
    }

    @NonNull
    public ConferenceState getConferenceState() {
        return state;
    }

    /**
     * Set if the user asked for video in this conference state
     * Helpful to deal with new privacy features in Android P+
     *
     * @param ownVideoStarted a boolean indicating the proper state
     */
    public void setOwnVideoStarted(boolean ownVideoStarted) {
        mOwnVideoStarted = ownVideoStarted;
    }

    /**
     * Return if the user asked for video in this conference state
     * Helpful to deal with new privacy features in Android P+
     *
     * @return a boolean indicating the proper state
     */
    public boolean isOwnVideoStarted() {
        return mOwnVideoStarted;
    }
}
