/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core;

import android.app.Application;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.widget.Toast;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.voxeet.android.media.MediaSDK;
import com.voxeet.kernel.R;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import okhttp3.OkHttpClient;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.EventBusException;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import retrofit2.Retrofit;
import voxeet.com.sdk.core.AbstractVoxeetService;
import voxeet.com.sdk.core.VoxeetHttp;
import voxeet.com.sdk.core.VoxeetWebSocket;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkService;
import voxeet.com.sdk.core.preferences.VoxeetPreferences;
import voxeet.com.sdk.core.services.AudioService;
import voxeet.com.sdk.core.services.ConferenceService;
import voxeet.com.sdk.core.services.LocalStatsService;
import voxeet.com.sdk.core.services.MediaService;
import voxeet.com.sdk.core.services.ScreenShareService;
import voxeet.com.sdk.core.services.UserService;
import voxeet.com.sdk.core.services.authenticate.WebSocketState;
import voxeet.com.sdk.core.services.authenticate.token.RefreshTokenCallback;
import voxeet.com.sdk.events.error.SocketConnectErrorEvent;
import voxeet.com.sdk.events.success.SocketConnectEvent;
import voxeet.com.sdk.events.success.SocketStateChangeEvent;
import voxeet.com.sdk.factories.EventsFactory;
import voxeet.com.sdk.json.Event;
import voxeet.com.sdk.json.UserInfo;
import voxeet.com.sdk.utils.ConferenceListener;
import voxeet.com.sdk.utils.Twig;
import voxeet.com.sdk.utils.VoxeetServerUrl;

public abstract class VoxeetSdkTemplate<T extends AbstractConferenceSdkService>
implements ConferenceListener {
    static final long DEFAULT_TIMEOUT_MS = 60000L;
    private static final String TAG = "VoxeetSdk";
    private UserInfo _user_info;
    private VoxeetWebSocket _voxeet_websocket;
    private VoxeetHttp _voxeet_http;
    protected Context _application_context;
    protected EventBus _event_bus;
    private Twig _twig;
    private VoxeetServerUrl _voxeet_server_url;
    private HashMap<Class<? extends AbstractVoxeetService>, AbstractVoxeetService> _services;
    private List<Solver<Boolean>> mWaitForLogInSocket;
    private ReentrantLock lockConnectAttempt = new ReentrantLock();
    private boolean loginIn = false;

    private VoxeetSdkTemplate() {
    }

    protected VoxeetSdkTemplate(@NonNull Application application_context, @NonNull String appId, @NonNull String password, @NonNull UserInfo userInfo, boolean debug) {
        this(application_context, appId, password, userInfo, null, null, debug);
    }

    protected VoxeetSdkTemplate(@NonNull Application application_context, @NonNull String tokenAccess, @Nullable RefreshTokenCallback tokenRefresh, @NonNull UserInfo userInfo, boolean debug) {
        this(application_context, null, null, userInfo, tokenAccess, tokenRefresh, debug);
    }

    private VoxeetSdkTemplate(@NonNull Application application_context, @Nullable String appId, @Nullable String password, @NonNull UserInfo userInfo, @Nullable String tokenAccess, @Nullable RefreshTokenCallback tokenRefresh, boolean debug) {
        this();
        this.mWaitForLogInSocket = new ArrayList<Solver<Boolean>>();
        this._application_context = application_context;
        this._event_bus = EventBus.getDefault();
        Promise.setHandler((Handler)new Handler(Looper.getMainLooper()));
        this.onSdkPreinit();
        this._user_info = userInfo;
        Log.d((String)"VoxeetSDK", (String)"VoxeetSdkTemplate: version := 1.4.12");
        this._twig = new Twig(2, "VoxeetSDK :: " + this.getTag(), false);
        this._voxeet_server_url = new VoxeetServerUrl(this);
        this._voxeet_websocket = new VoxeetWebSocket((Context)application_context, this, this._voxeet_server_url.getSocketUrl());
        VoxeetHttp.Builder builder = new VoxeetHttp.Builder().setApplication(application_context).setVoxeetSDK(this).setServerUrl(this._voxeet_server_url.getServerUrl()).setServerPort(this._voxeet_server_url.getServerPort()).setAppId(appId).setPassword(password).setTokenAccess(tokenAccess).setTokenRefresh(tokenRefresh).setVoxeetServiceListener(new VoxeetHttp.VoxeetServiceListener(){

            @Override
            public void onIdentifySuccess(VoxeetHttp provider) {
                VoxeetSdkTemplate.this._voxeet_websocket.connect(provider);
            }

            @Override
            public void onIdentifyError(String error) {
                if (null == error) {
                    error = "identfify error";
                }
                Log.e((String)VoxeetSdkTemplate.this.getTag(), (String)error);
                VoxeetSdkTemplate.this._event_bus.post((Object)new SocketStateChangeEvent(WebSocketState.CLOSED.name()));
            }

            @Override
            public void onNetworkError(UnknownHostException error) {
                VoxeetSdkTemplate.this._event_bus.post((Object)new SocketStateChangeEvent(WebSocketState.CLOSED.name()));
            }
        }).setDebug(debug);
        this._voxeet_http = builder.build();
        this._services = new HashMap();
        if (!this._event_bus.isRegistered(this)) {
            this._event_bus.register(this);
        }
        VoxeetPreferences.init(this.getApplicationContext());
        this.initServices();
    }

    public void resetVoxeetHttp() {
        this._voxeet_http.resetVoxeetHttp();
    }

    @Deprecated
    public void logUser(@NonNull UserInfo userInfo) {
        this._user_info = userInfo;
        this.logUserWithChain(userInfo).then((PromiseExec)new PromiseExec<Boolean, Object>(){

            public void onCall(@Nullable Boolean result, @NonNull Solver<Object> solver) {
                Log.d((String)VoxeetSdkTemplate.TAG, (String)"onCall: deprecated logUser method finished");
            }
        }).error(new ErrorPromise(){

            public void onError(@NonNull Throwable error) {
                error.printStackTrace();
            }
        });
    }

    public Promise<Boolean> logUserWithChain(@NonNull UserInfo userInfo) {
        this._user_info = userInfo;
        return this.logCurrentlySelectedUserWithChain();
    }

    public Promise<Boolean> logCurrentlySelectedUserWithChain() {
        if (this.isSocketOpen()) {
            return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

                public void onCall(@NonNull Solver<Boolean> solver) {
                    Log.d((String)VoxeetSdkTemplate.TAG, (String)"onCall: socket opened");
                    VoxeetSdkTemplate.this.lockConnectAttempt();
                    VoxeetSdkTemplate.this.resolveLoginSockets();
                    VoxeetSdkTemplate.this.unlockConnectAttempt();
                    solver.resolve((Object)true);
                }
            });
        }
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(@NonNull Solver<Boolean> solver) {
                if (null != VoxeetSdkTemplate.this._voxeet_websocket && VoxeetSdkTemplate.this.isSocketOpen()) {
                    VoxeetSdkTemplate.this._voxeet_websocket.close(true);
                }
                Log.d((String)VoxeetSdkTemplate.TAG, (String)"onCall: start login in promise");
                VoxeetSdkTemplate.this.lockConnectAttempt();
                Log.d((String)VoxeetSdkTemplate.TAG, (String)("onCall: having the list with elements := " + VoxeetSdkTemplate.this.mWaitForLogInSocket));
                if (VoxeetSdkTemplate.this.mWaitForLogInSocket.size() == 0) {
                    VoxeetSdkTemplate.this.mWaitForLogInSocket.add(solver);
                    VoxeetSdkTemplate.this.unlockConnectAttempt();
                    VoxeetSdkTemplate.this.openSdkSessionChain().then((PromiseExec)new PromiseExec<Boolean, Object>(){

                        public void onCall(@Nullable Boolean result, @NonNull Solver<Object> solver) {
                            Log.d((String)VoxeetSdkTemplate.TAG, (String)"onCall: first login part done");
                        }
                    }).error(new ErrorPromise(){

                        public void onError(@NonNull Throwable error) {
                            Log.d((String)VoxeetSdkTemplate.TAG, (String)("onError: login error " + error.getMessage()));
                            VoxeetSdkTemplate.this.lockConnectAttempt();
                            VoxeetSdkTemplate.this.rejectLoginSockets(error);
                            VoxeetSdkTemplate.this.clearLoginSockets();
                            VoxeetSdkTemplate.this.unlockConnectAttempt();
                            Log.d((String)VoxeetSdkTemplate.TAG, (String)"onError: login error managed");
                        }
                    });
                } else {
                    Log.d((String)VoxeetSdkTemplate.TAG, (String)"onCall: already have a login attempt in progress");
                    try {
                        throw new IllegalStateException("Can not open a session while an other one is trying to be started");
                    }
                    catch (Exception e) {
                        solver.reject((Throwable)e);
                        VoxeetSdkTemplate.this.unlockConnectAttempt();
                    }
                }
                Log.d((String)VoxeetSdkTemplate.TAG, (String)"onCall: start login done... can take a time");
            }
        });
    }

    public abstract Promise<Boolean> logout();

    protected void onLogoutCleanLoginSockets() {
        this.lockConnectAttempt();
        try {
            throw new IllegalStateException("You have awaiting login, the logout automatically canceled those");
        }
        catch (Exception e) {
            this.rejectLoginSockets(e);
            this.clearLoginSockets();
            this.unlockConnectAttempt();
            return;
        }
    }

    public abstract void onSdkPreinit();

    protected abstract void initServices();

    protected HashMap<Class<? extends AbstractVoxeetService>, AbstractVoxeetService> getServices() {
        return this._services;
    }

    public T getConferenceService() {
        return (T)this.getServiceForKlass(AbstractConferenceSdkService.class);
    }

    public ScreenShareService getScreenShareService() {
        return this.getServiceForKlass(ScreenShareService.class);
    }

    public AudioService getAudioService() {
        return this.getServiceForKlass(AudioService.class);
    }

    public void sendConferenceReminder(List<String> ids) {
        ConferenceService service = this.getServiceForKlass(ConferenceService.class);
        if (service != null) {
            service.sendReminder(ids);
        }
    }

    protected <T extends AbstractVoxeetService> T getServiceForKlass(Class<T> klass) {
        AbstractVoxeetService service = null;
        for (Class<? extends AbstractVoxeetService> next : this._services.keySet()) {
            AbstractVoxeetService item = this._services.get(next);
            if (!klass.isInstance(item)) continue;
            service = item;
        }
        if (service == null) {
            this.getTwig().e(klass.getSimpleName() + " not found in the list of services", new Object[0]);
        }
        return (T)service;
    }

    public void sendConferenceMessage(String message) {
        AbstractConferenceSdkService service = this.getServiceForKlass(AbstractConferenceSdkService.class);
        if (service != null) {
            service.sendBroadcastMessage(message);
        }
    }

    public void getUploadToken() {
        UserService service = this.getServiceForKlass(UserService.class);
        if (service != null) {
            service.getUploadToken();
        }
    }

    public void send(Event command) {
        ObjectMapper om = new ObjectMapper();
        try {
            this.sendConferenceMessage(om.writeValueAsString((Object)command));
        }
        catch (JsonProcessingException e) {
            Log.e((String)Event.TAG, (String)"failed to send command", (Throwable)e);
        }
    }

    public Event decode(String message) {
        return EventsFactory.decode(message);
    }

    public Twig getTwig() {
        return this._twig;
    }

    public Retrofit getRetrofit() {
        return this._voxeet_http.getRetrofit();
    }

    public OkHttpClient getClient() {
        return this._voxeet_http.getClient();
    }

    public Context getApplicationContext() {
        return this._application_context;
    }

    public VoxeetServerUrl getVoxeetServerUrl() {
        return this._voxeet_server_url;
    }

    public void resetServices() {
        for (Class<? extends AbstractVoxeetService> next : this._services.keySet()) {
            this._services.get(next).resetService();
        }
    }

    public EventBus getEventBus() {
        return this._event_bus;
    }

    protected VoxeetWebSocket getSocket() {
        return this._voxeet_websocket;
    }

    protected VoxeetHttp getVoxeetHttp() {
        return this._voxeet_http;
    }

    public void closeSocket() {
        this._voxeet_websocket.close(true);
    }

    public void cleanUserSession(@NonNull String id) {
        this._voxeet_http.cleanUserSession(id);
    }

    public boolean isSocketOpen() {
        return this._voxeet_websocket.isOpen();
    }

    public void openSdkSession() {
        this._voxeet_http.identify(this._user_info);
    }

    private Promise<Boolean> openSdkSessionChain() {
        return this._voxeet_http.identifyChain(this._user_info);
    }

    public UserInfo getUserInfo() {
        return this._user_info;
    }

    @Override
    public Promise<Boolean> onCreationSuccess(String conferenceId) {
        AbstractConferenceSdkService service = this.getServiceForKlass(AbstractConferenceSdkService.class);
        if (service != null) {
            return service.joinUsingConferenceId(conferenceId);
        }
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(@NonNull Solver<Boolean> solver) {
                solver.resolve((Object)false);
            }
        });
    }

    protected abstract String getTag();

    public boolean register(@NonNull Context context) {
        return this.register(context, null);
    }

    public boolean register(@NonNull Context context, @Nullable Object subscriber) {
        try {
            MediaSDK.setContext(context);
            if (null != subscriber && !this.getEventBus().isRegistered(subscriber)) {
                this.getEventBus().register(subscriber);
            }
        }
        catch (EventBusException eventBusException) {
        }
        catch (UnsatisfiedLinkError error) {
            Toast.makeText((Context)this.getApplicationContext(), (CharSequence)context.getString(R.string.register_conf_error), (int)0).show();
            return false;
        }
        return true;
    }

    public void unregister(@NonNull Object subscriber) {
        if (this.getEventBus().isRegistered(subscriber)) {
            this.getEventBus().unregister(subscriber);
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(SocketConnectEvent event) {
        Log.d((String)TAG, (String)"onEvent: ");
        this.lockConnectAttempt();
        this.resolveLoginSockets();
        this.unlockConnectAttempt();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(SocketConnectErrorEvent event) {
        this.lockConnectAttempt();
        for (int i = 0; i < this.mWaitForLogInSocket.size(); ++i) {
            Log.d((String)TAG, (String)"onEvent: calling resolved false");
            Solver<Boolean> solver = this.mWaitForLogInSocket.get(i);
            try {
                solver.resolve((Object)false);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.clearLoginSockets();
        this.unlockConnectAttempt();
    }

    @NonNull
    public MediaService getMediaService() {
        return this.getServiceForKlass(MediaService.class);
    }

    @NonNull
    public LocalStatsService getLocalStatsService() {
        return this.getServiceForKlass(LocalStatsService.class);
    }

    protected void lockConnectAttempt() {
        try {
            this.lockConnectAttempt.lock();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void unlockConnectAttempt() {
        try {
            if (this.lockConnectAttempt.isLocked()) {
                this.lockConnectAttempt.unlock();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void rejectLoginSockets(@Nullable Throwable error) {
        try {
            for (int i = 0; i < this.mWaitForLogInSocket.size(); ++i) {
                Log.d((String)TAG, (String)"onError: calling reject");
                Solver<Boolean> solver = this.mWaitForLogInSocket.get(i);
                try {
                    solver.reject(error);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    protected void resolveLoginSockets() {
        try {
            for (int i = 0; i < this.mWaitForLogInSocket.size(); ++i) {
                Log.d((String)TAG, (String)"onEvent: calling resolved true");
                Solver<Boolean> solver = this.mWaitForLogInSocket.get(i);
                try {
                    solver.resolve((Object)true);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.clearLoginSockets();
    }

    protected void clearLoginSockets() {
        try {
            this.mWaitForLogInSocket.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

