/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.android.media.audio;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioDeviceInfo;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.Window;
import com.voxeet.android.media.audio.AudioRoute;
import com.voxeet.android.media.audio.IMediaStateListener;
import com.voxeet.android.media.audio.focus.AudioFocusManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eventbus.EventBus;
import voxeet.com.sdk.events.AudioRouteChangeEvent;
import voxeet.com.sdk.utils.Validate;

public class AudioManager {
    public static final String MEDIA_OUPUT_ROUTE_INTENT = "media-output-route-intent";
    private static final String TAG = AudioManager.class.getSimpleName();
    private Context mContext;
    private boolean isBluetoothScoStarted;
    private Handler handler = new Handler();
    private android.media.AudioManager mServiceAudioManager;
    private HeadsetStateReceiver mHeadsetStateReceiver;
    private BluetoothHeadset mCurrentBluetoothHeadset;
    private BluetoothHeadsetListener mBluetoothHeadsetListener;
    private BluetoothAdapter mBluetoothAdapter;
    private AudioRoute mOutputRoute = AudioRoute.ROUTE_PHONE;
    private List<IMediaStateListener> mMediaStateListeners;
    private int mSoundType;
    private AudioFocusManager manager;
    private Runnable runnableBluetoothSco = new Runnable(){

        @Override
        public void run() {
            AudioManager.this.requestAudioFocus();
            try {
                AudioManager.this.mServiceAudioManager.startBluetoothSco();
                AudioManager.this.mServiceAudioManager.setBluetoothScoOn(true);
                AudioManager.this.isBluetoothScoStarted = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                AudioManager.this.isBluetoothScoStarted = false;
            }
        }
    };

    public void requestAudioFocus() {
        this.manager.requestAudioFocus(this.mServiceAudioManager);
    }

    public void abandonAudioFocusRequest() {
        this.manager.abandonAudioFocus(this.mServiceAudioManager);
    }

    private AudioManager() {
    }

    public AudioManager(Context context) {
        this();
        this.manager = new AudioFocusManager();
        this.mContext = context;
        this.mMediaStateListeners = new ArrayList<IMediaStateListener>();
        this.mHeadsetStateReceiver = new HeadsetStateReceiver();
        this.mBluetoothHeadsetListener = new BluetoothHeadsetListener();
        this.mCurrentBluetoothHeadset = null;
        this.isBluetoothScoStarted = false;
        this.mServiceAudioManager = (android.media.AudioManager)context.getSystemService("audio");
        this.checkForBluetoothDeviceAtStartUp();
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.mBluetoothAdapter != null) {
            try {
                this.mBluetoothAdapter.getProfileProxy(context, (BluetoothProfile.ServiceListener)this.mBluetoothHeadsetListener, 1);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
        this.mSoundType = this.getUiSoundsStreamType();
        context.registerReceiver((BroadcastReceiver)this.mHeadsetStateReceiver, new IntentFilter("android.intent.action.HEADSET_PLUG"));
        context.registerReceiver((BroadcastReceiver)this.mHeadsetStateReceiver, new IntentFilter("android.bluetooth.device.action.ACL_CONNECTED"));
        context.registerReceiver((BroadcastReceiver)this.mHeadsetStateReceiver, new IntentFilter("android.bluetooth.device.action.ACL_DISCONNECTED"));
        context.registerReceiver((BroadcastReceiver)this.mHeadsetStateReceiver, new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED"));
        context.registerReceiver((BroadcastReceiver)this.mHeadsetStateReceiver, new IntentFilter("android.media.SCO_AUDIO_STATE_CHANGED"));
    }

    public void stop() {
        this.setBluetooth(false);
        this.mContext.unregisterReceiver((BroadcastReceiver)this.mHeadsetStateReceiver);
        if (this.mCurrentBluetoothHeadset != null && this.mBluetoothAdapter != null) {
            this.mBluetoothAdapter.closeProfileProxy(1, (BluetoothProfile)this.mCurrentBluetoothHeadset);
        }
    }

    public boolean isWiredHeadsetOn() {
        return this.mServiceAudioManager.isWiredHeadsetOn();
    }

    @NonNull
    public List<AudioRoute> availableRoutes() {
        ArrayList<AudioRoute> routes = new ArrayList<AudioRoute>();
        routes.add(AudioRoute.ROUTE_SPEAKER);
        if (this.isWiredHeadsetOn()) {
            routes.add(AudioRoute.ROUTE_HEADSET);
        } else {
            routes.add(AudioRoute.ROUTE_PHONE);
        }
        if (this.isBluetoothHeadsetConnected()) {
            routes.add(AudioRoute.ROUTE_BLUETOOTH);
        }
        return routes;
    }

    @NonNull
    public AudioRoute outputRoute() {
        return this.mOutputRoute;
    }

    public boolean setOutputRoute(@NonNull AudioRoute route) {
        if (null == route) {
            return false;
        }
        switch (route) {
            case ROUTE_BLUETOOTH: {
                if (!this.isBluetoothHeadsetConnected()) break;
                this.setBluetooth(true);
                break;
            }
            case ROUTE_HEADSET: 
            case ROUTE_PHONE: {
                this.setSpeakerMode(false);
                break;
            }
            case ROUTE_SPEAKER: {
                if (this.isWiredHeadsetOn() || this.isBluetoothHeadsetConnected()) {
                    return false;
                }
                this.setSpeakerMode(true);
                break;
            }
        }
        EventBus.getDefault().post((Object)new AudioRouteChangeEvent());
        return true;
    }

    public void setVolumeControlStream(Window window, int streamType) {
        window.setVolumeControlStream(streamType);
    }

    public void setSpeakerPhoneMode(boolean mode) {
        this.mServiceAudioManager.setSpeakerphoneOn(mode);
        if (mode) {
            this.setBluetooth(false);
        }
        this.mServiceAudioManager.setSpeakerphoneOn(mode);
        this.mServiceAudioManager.setMode(0);
        this.forceVolumeControlStream(0);
        this.checkOutputRoute();
    }

    public void setSpeakerMode(boolean speakerMode) {
        if (speakerMode) {
            this.setBluetooth(false);
        }
        if ("samsung".equalsIgnoreCase(Build.BRAND)) {
            int requiredSpeakerMode = 3;
            if (speakerMode) {
                this.mServiceAudioManager.setSpeakerphoneOn(true);
                this.mServiceAudioManager.setMode(-1);
            } else {
                this.mServiceAudioManager.setSpeakerphoneOn(speakerMode);
                if (this.mServiceAudioManager.isWiredHeadsetOn()) {
                    this.mServiceAudioManager.setMode(-1);
                } else {
                    this.mServiceAudioManager.setMode(requiredSpeakerMode);
                }
            }
        } else {
            this.mServiceAudioManager.setSpeakerphoneOn(speakerMode);
            this.forceVolumeControlStream(0);
        }
        for (IMediaStateListener listeners : this.mMediaStateListeners) {
            listeners.onSpeakerChanged(speakerMode);
        }
        this.checkOutputRoute();
    }

    public void setBluetooth(boolean isEnabled) {
        this.forceVolumeControlStream(0);
        this.checkOutputRoute();
        try {
            if (isEnabled) {
                this.startBluetoothSco();
            } else {
                this.stopBluetoothSco();
            }
        }
        catch (NullPointerException e) {
            Log.d((String)TAG, (String)"No bluetooth headset connected");
        }
    }

    public void registerMediaState(@NonNull IMediaStateListener listener) {
        if (!this.mMediaStateListeners.contains(listener)) {
            this.mMediaStateListeners.add(listener);
        }
    }

    public void unregisterMediaState(@NonNull IMediaStateListener listener) {
        if (this.mMediaStateListeners.contains(listener)) {
            this.mMediaStateListeners.remove(listener);
        }
    }

    protected void checkOutputRoute() {
        if (null == this.mServiceAudioManager) {
            Log.e((String)TAG, (String)"checkOutputRoute: ERROR SERVICE AUDIO MANAGER NULL");
        }
        if (null == this.mContext) {
            Log.e((String)TAG, (String)"checkOutputRoute: ERROR CONTEXT NULL");
        }
        this.mOutputRoute = this.isBluetoothScoStarted ? AudioRoute.ROUTE_BLUETOOTH : (null != this.mServiceAudioManager && this.mServiceAudioManager.isSpeakerphoneOn() ? AudioRoute.ROUTE_SPEAKER : (null != this.mServiceAudioManager && this.mServiceAudioManager.isWiredHeadsetOn() ? AudioRoute.ROUTE_HEADSET : AudioRoute.ROUTE_PHONE));
        Log.d((String)TAG, (String)("checkOutputRoute: route := " + (Object)((Object)this.mOutputRoute)));
        Intent intent = new Intent(MEDIA_OUPUT_ROUTE_INTENT);
        intent.putExtra("route", this.mOutputRoute.value());
        Log.d((String)TAG, (String)"checkOutputRoute: also requestAudioFocus");
        this.requestAudioFocus();
        if (null != this.mContext) {
            this.mContext.sendBroadcast(intent);
        }
    }

    public int getDefaultSoundStreamType() {
        return this.mSoundType;
    }

    public void resetDefaultSoundType() {
        if (this.mSoundType >= 0) {
            this.forceVolumeControlStream(this.mSoundType);
        }
    }

    private int getUiSoundsStreamType() {
        try {
            Method method = this.mServiceAudioManager.getClass().getDeclaredMethod("getUiSoundsStreamType", new Class[0]);
            Object result = method.invoke((Object)this.mServiceAudioManager, new Object[0]);
            return (Integer)result;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return 1;
    }

    public void forceVolumeControlStream(int type) {
        try {
            Method method = this.mServiceAudioManager.getClass().getDeclaredMethod("forceVolumeControlStream", Integer.TYPE);
            method.invoke((Object)this.mServiceAudioManager, type);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public boolean isBluetoothHeadsetConnected() {
        this.checkForBluetoothDeviceAtStartUp();
        return this.isBluetoothScoStarted;
    }

    public boolean isHeadphonesPlugged() {
        if (Build.VERSION.SDK_INT >= 23) {
            AudioDeviceInfo[] audioDevices;
            for (AudioDeviceInfo deviceInfo : audioDevices = this.mServiceAudioManager.getDevices(3)) {
                Log.d((String)TAG, (String)("isHeadphonesPlugged: " + deviceInfo.getProductName() + " " + deviceInfo.isSource() + " " + deviceInfo.isSink()));
                if (deviceInfo.getType() != 4 && deviceInfo.getType() != 3 && deviceInfo.getType() != 7 && deviceInfo.getType() != 8) continue;
                return true;
            }
        } else {
            return this.isWiredHeadsetOn() || this.isBluetoothHeadsetConnected();
        }
        return false;
    }

    private void checkForBluetoothDeviceAtStartUp() {
        Log.d((String)TAG, (String)"checkForBluetoothDeviceAtStartUp");
        try {
            if (Build.VERSION.SDK_INT >= 23) {
                AudioDeviceInfo[] audioDevices;
                for (AudioDeviceInfo deviceInfo : audioDevices = this.mServiceAudioManager.getDevices(3)) {
                    Log.d((String)TAG, (String)("checkForBluetoothDeviceAtStartUp: " + deviceInfo.getProductName() + " " + deviceInfo.isSource() + " " + deviceInfo.isSink()));
                    if (deviceInfo.getType() != 7 && deviceInfo.getType() != 8) continue;
                    this.isBluetoothScoStarted = true;
                }
            } else {
                BluetoothAdapter mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
                if (mBluetoothAdapter != null && mBluetoothAdapter.isEnabled() && mBluetoothAdapter.getProfileConnectionState(1) == 2) {
                    this.isBluetoothScoStarted = true;
                }
            }
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"checkForBluetoothDeviceAtStartUp: exception thrown, have you the BLUETOOTH permission?");
            e.printStackTrace();
        }
    }

    private void startBluetoothSco() {
        this.handler.postDelayed(this.runnableBluetoothSco, 3000L);
    }

    private void stopBluetoothSco() {
        this.handler.removeCallbacks(this.runnableBluetoothSco);
        if (this.isBluetoothScoStarted) {
            try {
                this.mServiceAudioManager.setBluetoothScoOn(false);
                this.mServiceAudioManager.stopBluetoothSco();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.isBluetoothScoStarted = false;
        }
    }

    private void updateBluetoothHeadsetConnectivity(@Nullable BluetoothDevice device) {
        Log.d((String)TAG, (String)("updateBluetoothHeadsetConnectivity: " + device));
        if (null != this.mCurrentBluetoothHeadset) {
            if (Validate.hasBluetoothPermissions(this.mContext)) {
                this.isBluetoothScoStarted = this.mCurrentBluetoothHeadset.getConnectedDevices().size() > 0;
                this.isBluetoothScoStarted |= null != device;
            } else {
                Log.e((String)TAG, (String)"onServiceConnected: BLUETOOTH PERMISSION MISSING");
            }
            for (IMediaStateListener listeners : this.mMediaStateListeners) {
                listeners.onBluetoothHeadsetStateChange(this.isBluetoothScoStarted);
            }
            Log.d((String)TAG, (String)("onServiceConnected: isBluetoothScoStarted = " + this.isBluetoothScoStarted));
            this.startBluetoothSco();
            this.checkOutputRoute();
            EventBus.getDefault().post((Object)new AudioRouteChangeEvent());
        }
    }

    private class HeadsetStateReceiver
    extends BroadcastReceiver {
        private HeadsetStateReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            Log.d((String)TAG, (String)("onReceive: " + intent.getAction()));
            String action = intent.getAction();
            if (null == action) {
                action = "";
            }
            block6 : switch (action) {
                case "android.intent.action.HEADSET_PLUG": {
                    boolean isPlugged;
                    int state = intent.getIntExtra("state", -1);
                    int has_mic = intent.getIntExtra("microphone", -1);
                    boolean bl = isPlugged = state == 1 && has_mic == 1;
                    if (isPlugged) {
                        for (IMediaStateListener listeners : AudioManager.this.mMediaStateListeners) {
                            listeners.onHeadsetStateChange(true);
                        }
                        AudioManager.this.setSpeakerMode(false);
                        AudioManager.this.checkOutputRoute();
                        EventBus.getDefault().post((Object)new AudioRouteChangeEvent());
                        break;
                    }
                    for (IMediaStateListener listeners : AudioManager.this.mMediaStateListeners) {
                        listeners.onHeadsetStateChange(false);
                    }
                    AudioManager.this.checkOutputRoute();
                    EventBus.getDefault().post((Object)new AudioRouteChangeEvent());
                    break;
                }
                case "android.bluetooth.device.action.ACL_CONNECTED": {
                    BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    AudioManager.this.updateBluetoothHeadsetConnectivity(device);
                    break;
                }
                case "android.bluetooth.device.action.ACL_DISCONNECTED": {
                    AudioManager.this.updateBluetoothHeadsetConnectivity(null);
                    break;
                }
                case "android.media.SCO_AUDIO_STATE_CHANGED": {
                    int l_state = intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", -1);
                    Log.d((String)TAG, (String)"Audio SCO: android.media.SCO_AUDIO_STATE_CHANGED");
                    switch (l_state) {
                        case 1: {
                            Log.i((String)TAG, (String)"SCO_AUDIO_STATE_CONNECTED");
                            AudioManager.this.requestAudioFocus();
                            break block6;
                        }
                        case 0: {
                            Log.e((String)TAG, (String)"SCO_AUDIO_STATE_DISCONNECTED");
                            AudioManager.this.requestAudioFocus();
                            break block6;
                        }
                    }
                    Log.e((String)TAG, (String)("unknown state received:" + l_state));
                }
            }
        }
    }

    private class BluetoothHeadsetListener
    implements BluetoothProfile.ServiceListener {
        private BluetoothHeadsetListener() {
        }

        public void onServiceConnected(int i, BluetoothProfile bluetoothProfile) {
            if (bluetoothProfile instanceof BluetoothHeadset) {
                AudioManager.this.mCurrentBluetoothHeadset = (BluetoothHeadset)bluetoothProfile;
            }
            AudioManager.this.updateBluetoothHeadsetConnectivity(null);
        }

        public void onServiceDisconnected(int i) {
            AudioManager.this.mCurrentBluetoothHeadset = null;
            AudioManager.this.isBluetoothScoStarted = false;
            Log.d((String)TAG, (String)"onServiceDisconnected: isBluetoothScoStarted = true");
            for (IMediaStateListener listeners : AudioManager.this.mMediaStateListeners) {
                try {
                    listeners.onBluetoothHeadsetStateChange(false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            AudioManager.this.mServiceAudioManager.stopBluetoothSco();
            AudioManager.this.checkOutputRoute();
            EventBus.getDefault().post((Object)new AudioRouteChangeEvent());
        }
    }
}

