/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import voxeet.com.sdk.json.Event;
import voxeet.com.sdk.models.RecordingStatus;
import voxeet.com.sdk.models.impl.DefaultConference;
import voxeet.com.sdk.models.impl.DefaultConferenceInfos;
import voxeet.com.sdk.models.impl.DefaultConferenceUser;
import voxeet.com.sdk.models.impl.DefaultUserProfile;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeName(value="OwnUserInvitedEvent")
public class OwnUserInvited
extends Event {
    private String userId;
    @JsonProperty(value="conference")
    private DefaultConferenceInfos conferenceInfos;
    private List<DefaultUserProfile> guests;

    public List<DefaultUserProfile> getGuests() {
        return this.guests;
    }

    public void setGuests(List<DefaultUserProfile> guests) {
        this.guests = guests;
    }

    public DefaultConference getConference() {
        DefaultConference conference = new DefaultConference();
        conference.setConferenceInfos(this.conferenceInfos);
        conference.setHasBeenCreated(true);
        conference.setDemo(false);
        conference.setConferenceType(this.conferenceInfos.getConferenceType());
        conference.setMeetingId(this.conferenceInfos.getMeetingId());
        conference.setConferenceId(this.conferenceInfos.getConferenceId());
        conference.setDescription(this.conferenceInfos.getDescription());
        conference.setLocation(this.conferenceInfos.getLocation());
        conference.setGuestAccess(false);
        conference.setOffline(false);
        conference.setRecorded(false);
        conference.setRecordingStatus(RecordingStatus.NOT_RECORDING);
        for (DefaultUserProfile profile : this.guests) {
            conference.getConferenceUsers().add(new DefaultConferenceUser(profile));
        }
        return conference;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public DefaultConferenceInfos getConferenceInfos() {
        return this.conferenceInfos;
    }

    public void setConferenceInfos(DefaultConferenceInfos conferenceInfos) {
        this.conferenceInfos = conferenceInfos;
    }

    @Override
    public String getType() {
        return "OwnUserInvitedEvent";
    }
}

