package voxeet.com.sdk.core.services.localstats;

import android.support.annotation.Nullable;

public enum LocalStatsUserTypes {
    DEFAULT,
    CONNECTING,
    CONNECTED,
    FLUCTUATES,
    DISCONNECTED;

    /**
     * @param isDisconnected if the representing user is disconnected
     * @param isFluctuating  if the representing user is fluctuating
     * @return the new state or null if no modification
     */
    @Nullable
    public LocalStatsUserTypes next(boolean isDisconnected, boolean isFluctuating) {
        switch (this) {
            case CONNECTING:
            case FLUCTUATES:
                if (isDisconnected) return DISCONNECTED;
                if (isFluctuating) return null;
                return CONNECTED;
            case CONNECTED:
                if (isDisconnected) return DISCONNECTED;
                if (isFluctuating) return FLUCTUATES;
                return null;
            case DISCONNECTED:
                if (isDisconnected) return null;
                if (isFluctuating) return CONNECTING;
                return CONNECTED;
            case DEFAULT:
            default:
                if (isDisconnected) return DISCONNECTED;
                if (isFluctuating) return CONNECTING;
                return null;
        }
    }
}
