package com.voxeet.android.media.sensors;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.PowerManager;
import android.support.annotation.NonNull;
import android.util.Log;

public class ScreenSensor implements ConferenceLock {
    //private final static int FLAG = PowerManager.SCREEN_DIM_WAKE_LOCK;
    private final static int FLAG = PowerManager.SCREEN_BRIGHT_WAKE_LOCK;
    private PowerManager mPowerManager;
    private Context mContext;
    private PowerManager.WakeLock mProximityWakeLock;
    private Intent registered;
    private BroadcastReceiver screenOnReceiver;
    private boolean shouldAcquire;

    private ScreenSensor() {
        registered = null;
        shouldAcquire = false;
        screenOnReceiver = new BroadcastReceiver() {
            @Override
            public void onReceive(Context context, Intent intent) {
                if(shouldAcquire) {
                    acquire();
                }
            }
        };
    }

    public ScreenSensor(@NonNull Context context) {
        this();
        mContext = context;

        mPowerManager = (PowerManager) mContext.getSystemService(Context.POWER_SERVICE);

        mProximityWakeLock = mPowerManager.newWakeLock(FLAG, "Sensor:");
    }

    @Override
    public void acquire() {
        shouldAcquire = true;
        try {
            if (null != mProximityWakeLock && !mProximityWakeLock.isHeld()) {
                mProximityWakeLock.acquire();

                registered = mContext.registerReceiver(screenOnReceiver, new IntentFilter(Intent.ACTION_SCREEN_ON));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void release() {
        shouldAcquire = false;
        try {
            if (null != mProximityWakeLock && mProximityWakeLock.isHeld()) {
                mContext.unregisterReceiver(screenOnReceiver);
                mProximityWakeLock.release();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isProximity() {
        return false;
    }
}
