package voxeet.com.sdk.core.abs.information;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import java.util.HashMap;

/**
 * Created by kevinleperf on 29/08/2018.
 */

public class ConferenceInformationHolder {
    private HashMap<String, ConferenceInformation> mConferenceInformations;

    public ConferenceInformationHolder() {
        mConferenceInformations = new HashMap<>();
    }

    @Nullable
    public ConferenceInformation getInformation(@Nullable String conferenceId) {
        if(null == conferenceId) return null;

        ConferenceInformation information = null;

        if(mConferenceInformations.containsKey(conferenceId)) {
            information = mConferenceInformations.get(conferenceId);
        }

        if(null == information) {
            information = new ConferenceInformation(conferenceId);
            mConferenceInformations.put(conferenceId, information);
        }

        return information;
    }
}
