package voxeet.com.sdk.core.abs;

import com.voxeet.android.media.peer.SdpDescription;

import java.util.List;

import okhttp3.ResponseBody;
import retrofit2.Call;
import voxeet.com.sdk.events.success.GetConferenceStatusEvent;
import voxeet.com.sdk.events.success.ReplayConferenceEvent;
import voxeet.com.sdk.events.success.ResumeConference;
import voxeet.com.sdk.json.BroadcastEvent;
import voxeet.com.sdk.json.CreateConferenceParams;
import voxeet.com.sdk.json.DeviceEvent;
import voxeet.com.sdk.json.SdkConferenceInvitation;
import voxeet.com.sdk.json.SdkConferenceReplayBody;
import voxeet.com.sdk.json.StartScreenSharingResponse;
import voxeet.com.sdk.json.StartVideoResponse;
import voxeet.com.sdk.json.StopScreenSharingResponse;
import voxeet.com.sdk.json.StopVideoResponse;
import voxeet.com.sdk.models.CandidatesPush;
import voxeet.com.sdk.models.ConferenceResponse;
import voxeet.com.sdk.models.HistoryConference;
import voxeet.com.sdk.models.SubscribeConference;

/**
 * Created by kevinleperf on 13/11/2017.
 */

public abstract class AbstractConferenceSdkObservableProvider<T, DemoEvent> {

    protected abstract T getService();

    public abstract void setRetrofitInstantiatedProvider(T service);

    public abstract Class getRetrofitInjectedClass();

    public abstract Call<ResponseBody> leaveConference(String conferenceId);

    public abstract Call<ResponseBody> getDeclineObservable(String conferenceId);

    public abstract Call<StartVideoResponse> getStartVideoObservable(String conferenceId, String id);

    public abstract Call<StopVideoResponse> getStopVideoObservable(String conferenceId, String id);

    public abstract Call<StartScreenSharingResponse> getStartScreenShareObservable(String conferenceId, String id);

    public abstract Call<StopScreenSharingResponse> getStopScreenShareObservable(String conferenceId, String id);

    public abstract Call<ConferenceResponse> getCreateConferenceObservable(CreateConferenceParams params);

    public abstract Call<DemoEvent> getCreateDemoObservable();

    public abstract Call<ResponseBody> getInviteObservable(String conferenceId, SdkConferenceInvitation sdkConferenceInvitation);

    public abstract Call<ReplayConferenceEvent> getReplayObservable(String conferenceId, SdkConferenceReplayBody sdkConferenceReplayBody);

    public abstract Call<ResponseBody> getStartRecordingObservable(String conferenceId);

    public abstract Call<ResponseBody> getStopRecordingObservable(String conferenceId);

    public abstract Call<ResponseBody> getLogOutObservable(String token);

    public abstract Call<GetConferenceStatusEvent> getConferenceStatusObservable(String conferenceId);

    public abstract Call<List<HistoryConference>> getConferenceHistoryObservable(String conferenceId);

    public abstract Call<SubscribeConference> getSubscribeObservable(String conferenceId);

    public abstract Call<ResponseBody> getUnSubscribeObservable(String conferenceId);

    public abstract Call<ResponseBody> getSubscribeForCallObservable(String conferenceId);

    public abstract Call<ResponseBody> getUnSubscribeFromCallObservable(String conferenceId);

    public abstract Call<ResumeConference> joinConference(String conferenceId, DeviceEvent deviceEvent);

    public abstract Call<ResponseBody> answerConference(String conferenceId, String peer, SdpDescription description);

    public abstract Call<ResponseBody> broadcastMessage(String conferenceId, BroadcastEvent broadcastEvent);

    public abstract Call<ResponseBody> candidates(String conferenceId, String peerId, CandidatesPush candidates);

    public abstract Call<ResponseBody> renegociate(String conferenceId);

    public abstract Call<ResponseBody> iceRestart(String conferenceId);
}
