package voxeet.com.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.util.List;

import voxeet.com.sdk.core.preferences.VoxeetPreferences;
import voxeet.com.sdk.models.AddressBookContact;

@JsonIgnoreProperties(ignoreUnknown = true)
public class SyncAdressBookEvent {
    private String userId;

    private String deviceType;

    private String deviceId;

    private List<AddressBookContact> contacts;

    public SyncAdressBookEvent(List<AddressBookContact> contacts, String deviceId) {
        this.deviceType = "ANDROID";

        this.deviceId = deviceId;

        this.userId = VoxeetPreferences.id();

        this.contacts = contacts;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public List<AddressBookContact> getContacts() {
        return contacts;
    }

    public void setContacts(List<AddressBookContact> contacts) {
        this.contacts = contacts;
    }
}
