package voxeet.com.sdk.events.success;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import voxeet.com.sdk.events.BaseEvent;
import voxeet.com.sdk.models.impl.DefaultConferenceUser;

/**
 * Created by RomainB on 5/30/16.
 */
public class ConferenceRefreshedEvent extends BaseEvent {

    private final DefaultConferenceUser user;

    private final String userId;

    public ConferenceRefreshedEvent(@NonNull String userId, @Nullable DefaultConferenceUser user) {
        this.user = user;
        this.userId = userId;
    }

    public String getUserId() {
        return userId;
    }

    public DefaultConferenceUser getUser() {
        return user;
    }
}
