/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core;

import android.app.Application;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.widget.Toast;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.neovisionaries.ws.client.WebSocketState;
import com.voxeet.android.media.MediaSDK;
import com.voxeet.kernel.R;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantLock;
import okhttp3.OkHttpClient;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.EventBusException;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import retrofit2.Retrofit;
import voxeet.com.sdk.core.AbstractVoxeetService;
import voxeet.com.sdk.core.VoxeetHttp;
import voxeet.com.sdk.core.VoxeetWebSocket;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkService;
import voxeet.com.sdk.core.preferences.VoxeetPreferences;
import voxeet.com.sdk.core.services.AudioService;
import voxeet.com.sdk.core.services.ConferenceService;
import voxeet.com.sdk.core.services.LocalStatsService;
import voxeet.com.sdk.core.services.MediaService;
import voxeet.com.sdk.core.services.ScreenShareService;
import voxeet.com.sdk.core.services.UserService;
import voxeet.com.sdk.events.error.SocketConnectErrorEvent;
import voxeet.com.sdk.events.success.SocketConnectEvent;
import voxeet.com.sdk.events.success.SocketStateChangeEvent;
import voxeet.com.sdk.factories.EventsFactory;
import voxeet.com.sdk.json.Event;
import voxeet.com.sdk.json.UserInfo;
import voxeet.com.sdk.models.TokenResponse;
import voxeet.com.sdk.models.UserTokenResponse;
import voxeet.com.sdk.utils.ConferenceListener;
import voxeet.com.sdk.utils.Twig;
import voxeet.com.sdk.utils.VoxeetServerUrl;

public abstract class VoxeetSdkTemplate<T extends AbstractConferenceSdkService>
implements ConferenceListener {
    static final long DEFAULT_TIMEOUT_MS = 60000L;
    private UserInfo _user_info;
    private VoxeetWebSocket _voxeet_websocket;
    private VoxeetHttp _voxeet_http;
    protected Context _application_context;
    protected EventBus _event_bus;
    private Twig _twig;
    private VoxeetServerUrl _voxeet_server_url;
    private HashMap<Class<? extends AbstractVoxeetService>, AbstractVoxeetService> _services;
    private List<Solver<Boolean>> mWaitForLogInSocket;
    private ReentrantLock lockConnectAttempt = new ReentrantLock();

    private VoxeetSdkTemplate() {
    }

    protected VoxeetSdkTemplate(@NonNull Application application_context, @NonNull String appId, @NonNull String password, @NonNull UserInfo userInfo, boolean debug) {
        this(application_context, appId, password, userInfo, null, null, debug);
    }

    protected VoxeetSdkTemplate(@NonNull Application application_context, @NonNull String tokenAccess, @Nullable Callable<String> tokenRefresh, @NonNull UserInfo userInfo, boolean debug) {
        this(application_context, null, null, userInfo, tokenAccess, tokenRefresh, debug);
    }

    private VoxeetSdkTemplate(@NonNull Application application_context, @Nullable String appId, @Nullable String password, @NonNull UserInfo userInfo, @Nullable String tokenAccess, @Nullable Callable<String> tokenRefresh, boolean debug) {
        this();
        this.mWaitForLogInSocket = new ArrayList<Solver<Boolean>>();
        this._application_context = application_context;
        this._event_bus = EventBus.getDefault();
        Promise.setHandler((Handler)new Handler(Looper.getMainLooper()));
        this.onSdkPreinit();
        this._user_info = userInfo;
        Log.d((String)"VoxeetSDK", (String)"VoxeetSdkTemplate: version := 1.1.9");
        this._twig = new Twig(2, "VoxeetSDK :: " + this.getTag(), false);
        this._voxeet_server_url = new VoxeetServerUrl(this);
        this._voxeet_websocket = new VoxeetWebSocket((Context)application_context, this, this._voxeet_server_url.getSocketUrl());
        VoxeetHttp.Builder builder = new VoxeetHttp.Builder().setApplication(application_context).setVoxeetSDK(this).setServerUrl(this._voxeet_server_url.getServerUrl()).setServerPort(this._voxeet_server_url.getServerPort()).setAppId(appId).setPassword(password).setTokenAccess(tokenAccess).setTokenRefresh(tokenRefresh).setVoxeetServiceListener(new VoxeetHttp.VoxeetServiceListener(){

            @Override
            public void onIdentifySuccess(UserTokenResponse userToken, TokenResponse tokenResponse) {
                VoxeetSdkTemplate.this._voxeet_websocket.connect(userToken.getUserToken(), userToken.getJwtUserToken());
            }

            @Override
            public void onIdentifyError(String error) {
                if (null == error) {
                    error = "identfify error";
                }
                Log.e((String)VoxeetSdkTemplate.this.getTag(), (String)error);
                VoxeetSdkTemplate.this._event_bus.post((Object)new SocketStateChangeEvent(WebSocketState.CLOSED.name()));
            }

            @Override
            public void onNetworkError(UnknownHostException error) {
                VoxeetSdkTemplate.this._event_bus.post((Object)new SocketStateChangeEvent(WebSocketState.CLOSED.name()));
            }
        }).setDebug(debug);
        this._voxeet_http = builder.build();
        this._services = new HashMap();
        if (!this._event_bus.isRegistered(this)) {
            this._event_bus.register(this);
        }
        VoxeetPreferences.init(this.getApplicationContext());
        this.initServices();
    }

    public void resetVoxeetHttp() {
        this._voxeet_http.FORCE_TOKEN_RESET();
    }

    public void logUser(@NonNull UserInfo userInfo) {
        this._user_info = userInfo;
        this.openSdkSession();
    }

    public Promise<Boolean> logUserWithChain(@NonNull UserInfo userInfo) {
        this._user_info = userInfo;
        return this.logCurrentlySelectedUserWithChain();
    }

    public Promise<Boolean> logCurrentlySelectedUserWithChain() {
        if (this.isSocketOpen()) {
            return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

                public void onCall(@NonNull Solver<Boolean> solver) {
                    solver.resolve((Object)true);
                }
            });
        }
        Promise promise = new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> solver) {
                VoxeetSdkTemplate.this.lockConnectAttempt();
                VoxeetSdkTemplate.this.mWaitForLogInSocket.add(solver);
                if (VoxeetSdkTemplate.this.mWaitForLogInSocket.size() == 1) {
                    VoxeetSdkTemplate.this.unlockConnectAttempt();
                    VoxeetSdkTemplate.this.openSdkSessionChain().then((PromiseExec)new PromiseExec<Boolean, Object>(){

                        public void onCall(@Nullable Boolean result, @NonNull Solver<Object> solver) {
                        }
                    }).error(new ErrorPromise(){

                        public void onError(@NonNull Throwable error) {
                            solver.reject(error);
                            VoxeetSdkTemplate.this.lockConnectAttempt();
                            for (Solver solve : VoxeetSdkTemplate.this.mWaitForLogInSocket) {
                                solve.reject(error);
                            }
                            VoxeetSdkTemplate.this.mWaitForLogInSocket.clear();
                            VoxeetSdkTemplate.this.unlockConnectAttempt();
                        }
                    });
                } else {
                    VoxeetSdkTemplate.this.unlockConnectAttempt();
                }
            }
        });
        return promise;
    }

    public abstract Promise<Boolean> logout();

    public abstract void onSdkPreinit();

    protected abstract void initServices();

    protected HashMap<Class<? extends AbstractVoxeetService>, AbstractVoxeetService> getServices() {
        return this._services;
    }

    public T getConferenceService() {
        return (T)this.getServiceForKlass(AbstractConferenceSdkService.class);
    }

    public ScreenShareService getScreenShareService() {
        return this.getServiceForKlass(ScreenShareService.class);
    }

    public AudioService getAudioService() {
        return this.getServiceForKlass(AudioService.class);
    }

    public void sendConferenceReminder(List<String> ids) {
        ConferenceService service = this.getServiceForKlass(ConferenceService.class);
        if (service != null) {
            service.sendReminder(ids);
        }
    }

    protected <T extends AbstractVoxeetService> T getServiceForKlass(Class<T> klass) {
        AbstractVoxeetService service = null;
        for (Class<? extends AbstractVoxeetService> next : this._services.keySet()) {
            AbstractVoxeetService item = this._services.get(next);
            if (!klass.isInstance(item)) continue;
            service = item;
        }
        if (service == null) {
            this.getTwig().e(klass.getSimpleName() + " not found in the list of services", new Object[0]);
        }
        return (T)service;
    }

    public void sendConferenceMessage(String message) {
        AbstractConferenceSdkService service = this.getServiceForKlass(AbstractConferenceSdkService.class);
        if (service != null) {
            service.sendBroadcastMessage(message);
        }
    }

    public void getUploadToken() {
        UserService service = this.getServiceForKlass(UserService.class);
        if (service != null) {
            service.getUploadToken();
        }
    }

    public void send(Event command) {
        ObjectMapper om = new ObjectMapper();
        try {
            this.sendConferenceMessage(om.writeValueAsString((Object)command));
        }
        catch (JsonProcessingException e) {
            Log.e((String)Event.TAG, (String)"failed to send command", (Throwable)e);
        }
    }

    public Event decode(String message) {
        return EventsFactory.decode(message);
    }

    public Twig getTwig() {
        return this._twig;
    }

    public Retrofit getRetrofit() {
        return this._voxeet_http.getRetrofit();
    }

    public OkHttpClient getClient() {
        return this._voxeet_http.getClient();
    }

    public Context getApplicationContext() {
        return this._application_context;
    }

    public VoxeetServerUrl getVoxeetServerUrl() {
        return this._voxeet_server_url;
    }

    public void resetServices() {
        for (Class<? extends AbstractVoxeetService> next : this._services.keySet()) {
            this._services.get(next).resetService();
        }
    }

    public EventBus getEventBus() {
        return this._event_bus;
    }

    protected VoxeetWebSocket getSocket() {
        return this._voxeet_websocket;
    }

    protected VoxeetHttp getVoxeetHttp() {
        return this._voxeet_http;
    }

    public void closeSocket() {
        this._voxeet_websocket.close(true);
    }

    public boolean isSocketOpen() {
        return this._voxeet_websocket.isOpen();
    }

    public void openSdkSession() {
        this._voxeet_http.identify(this._user_info);
    }

    private Promise<Boolean> openSdkSessionChain() {
        return this._voxeet_http.identifyChain(this._user_info);
    }

    @Override
    public Promise<Boolean> onCreationSuccess(String conferenceId) {
        AbstractConferenceSdkService service = this.getServiceForKlass(AbstractConferenceSdkService.class);
        if (service != null) {
            return service.joinUsingConferenceId(conferenceId);
        }
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(@NonNull Solver<Boolean> solver) {
                solver.resolve((Object)false);
            }
        });
    }

    protected abstract String getTag();

    public boolean register(@NonNull Context context) {
        return this.register(context, null);
    }

    public boolean register(@NonNull Context context, @Nullable Object subscriber) {
        try {
            MediaSDK.setContext((Context)context);
            if (null != subscriber && !this.getEventBus().isRegistered(subscriber)) {
                this.getEventBus().register(subscriber);
            }
        }
        catch (EventBusException eventBusException) {
        }
        catch (UnsatisfiedLinkError error) {
            Toast.makeText((Context)this.getApplicationContext(), (CharSequence)context.getString(R.string.register_conf_error), (int)0).show();
            return false;
        }
        return true;
    }

    public void unregister(@NonNull Object subscriber) {
        if (this.getEventBus().isRegistered(subscriber)) {
            this.getEventBus().unregister(subscriber);
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(SocketConnectEvent event) {
        this.lockConnectAttempt();
        for (Solver<Boolean> solve : this.mWaitForLogInSocket) {
            solve.resolve((Object)true);
        }
        this.mWaitForLogInSocket.clear();
        this.unlockConnectAttempt();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(SocketConnectErrorEvent event) {
        this.lockConnectAttempt();
        for (Solver<Boolean> solve : this.mWaitForLogInSocket) {
            solve.resolve((Object)false);
        }
        this.mWaitForLogInSocket.clear();
        this.unlockConnectAttempt();
    }

    @NonNull
    public MediaService getMediaService() {
        return this.getServiceForKlass(MediaService.class);
    }

    @NonNull
    public LocalStatsService getLocalStatsService() {
        return this.getServiceForKlass(LocalStatsService.class);
    }

    private void lockConnectAttempt() {
        try {
            this.lockConnectAttempt.lock();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void unlockConnectAttempt() {
        try {
            if (this.lockConnectAttempt.isLocked()) {
                this.lockConnectAttempt.unlock();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

