/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.services;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import retrofit2.Response;
import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;
import rx.schedulers.Schedulers;
import voxeet.com.sdk.core.VoxeetSdkTemplate;
import voxeet.com.sdk.core.network.ISdkFilePresentationRService;
import voxeet.com.sdk.core.services.abstracts.AbstractPresentationService;
import voxeet.com.sdk.events.success.FileConvertedEvent;
import voxeet.com.sdk.events.success.FilePresentationStartedEvent;
import voxeet.com.sdk.events.success.FilePresentationStoppedEvent;
import voxeet.com.sdk.events.success.FilePresentationUpdatedEvent;
import voxeet.com.sdk.json.FileConverted;
import voxeet.com.sdk.json.FilePresentationStarted;
import voxeet.com.sdk.json.FilePresentationStopped;
import voxeet.com.sdk.json.FilePresentationUpdated;
import voxeet.com.sdk.models.FilePresentationConverted;
import voxeet.com.sdk.models.impl.DefaultFile;

public class SDKFilePresentationService
extends AbstractPresentationService<ISdkFilePresentationRService> {
    private static final String TAG = SDKFilePresentationService.class.getSimpleName();
    private HashMap<String, Solver<FilePresentationConverted>> mCacheSolvers = new HashMap();
    private HashMap<String, Solver<FilePresentationStarted>> mCacheStartedSolvers = new HashMap();
    private HashMap<String, Solver<FilePresentationStopped>> mCacheStoppedSolvers = new HashMap();
    private HashMap<String, Solver<FilePresentationUpdated>> mCacheUpdatedSolvers = new HashMap();

    public SDKFilePresentationService(VoxeetSdkTemplate instance) {
        super(instance, ISdkFilePresentationRService.class);
        this.registerEventBus();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(FilePresentationStartedEvent event) {
        this.tryUnlock(event.getEvent().getFileId(), event.getEvent(), this.mCacheStartedSolvers);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(FilePresentationStoppedEvent event) {
        this.tryUnlock(event.getEvent().getFileId(), event.getEvent(), this.mCacheStoppedSolvers);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(FilePresentationUpdatedEvent event) {
        this.tryUnlock(event.getEvent().getFileId(), event.getEvent(), this.mCacheUpdatedSolvers);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(FileConvertedEvent event) {
        if (null != event) {
            FileConverted converted = event.getEvent();
            List<DefaultFile> list = converted.getFiles();
            for (DefaultFile file : list) {
                Log.d((String)TAG, (String)("onEvent: " + file.getName()));
                String key = this.findSolverFor(file.getName());
                Log.d((String)TAG, (String)("onEvent: " + key));
                if (null == key) continue;
                FilePresentationConverted temp = new FilePresentationConverted(file.getName(), file.getFileId(), file.getSize(), file.getNbImageConverted());
                this.tryUnlock(key, temp, this.mCacheSolvers);
            }
        }
    }

    public String getImage(String fileId, int pageNumber) {
        return String.format("%s/v1/files/%s/converted/%d?token=%s", this.getURLRoot(this.getVoxeetSdkInstance()), fileId, pageNumber, this.getInternalJwtToken(this.getVoxeetSdkInstance()));
    }

    public String getThumbnail(String fileId, int pageNumber) {
        return String.format("%s/v1/files/%s/converted/%d/thumbnail?token=%s", this.getURLRoot(this.getVoxeetSdkInstance()), fileId, pageNumber, this.getInternalJwtToken(this.getVoxeetSdkInstance()));
    }

    @Nullable
    private String findSolverFor(@NonNull String name) {
        for (String value : this.mCacheSolvers.keySet()) {
            if (name.indexOf(value) != 0) continue;
            return value;
        }
        return null;
    }

    public Promise<FilePresentationConverted> convertFile(final File file) {
        return new Promise((PromiseSolver)new PromiseSolver<FilePresentationConverted>(){

            public void onCall(final @NonNull Solver<FilePresentationConverted> solver) {
                final String uuid = UUID.randomUUID().toString();
                String appended_name = uuid + file.getName();
                RequestBody requestFile = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)file);
                MultipartBody.Part body = MultipartBody.Part.createFormData((String)"file", (String)appended_name, (RequestBody)requestFile);
                ((ISdkFilePresentationRService)SDKFilePresentationService.this.getService()).convertFile(requestFile, body).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<Response<ResponseBody>>(){

                    public void onCompleted() {
                        Log.d((String)TAG, (String)"onCompleted: ");
                    }

                    public void onError(Throwable e) {
                        Log.d((String)TAG, (String)("onError: " + e));
                        solver.reject(e);
                    }

                    public void onNext(Response<ResponseBody> responseBodyResponse) {
                        SDKFilePresentationService.this.mCacheSolvers.put(uuid, solver);
                    }
                });
            }
        });
    }

    public Promise<FilePresentationStarted> startPresentation(@NonNull FilePresentationConverted body) {
        return this.startPresentation(body, 0);
    }

    public Promise<FilePresentationStarted> startPresentation(final @NonNull FilePresentationConverted body, final int position) {
        return new Promise((PromiseSolver)new PromiseSolver<FilePresentationStarted>(){

            public void onCall(@NonNull Solver<FilePresentationStarted> solver) {
                ISdkFilePresentationRService.FilePresentationId body_sent = new ISdkFilePresentationRService.FilePresentationId(body.getFileId(), body.getName(), position, body.getNbImageConverted());
                SDKFilePresentationService.this.consumeInternalCall(solver, body.getFileId(), SDKFilePresentationService.this.mCacheStartedSolvers, SDKFilePresentationService.this.internalCall((Observable<Response<ResponseBody>>)((ISdkFilePresentationRService)SDKFilePresentationService.this.getService()).startFilePresentation(SDKFilePresentationService.this.getConferenceId(), body_sent)));
            }
        });
    }

    public Promise<FilePresentationStopped> stopPresentation(final @NonNull String fileId) {
        return new Promise((PromiseSolver)new PromiseSolver<FilePresentationStopped>(){

            public void onCall(@NonNull Solver<FilePresentationStopped> solver) {
                ISdkFilePresentationRService.FilePresentationId body_sent = new ISdkFilePresentationRService.FilePresentationId(fileId);
                SDKFilePresentationService.this.consumeInternalCall(solver, fileId, SDKFilePresentationService.this.mCacheStoppedSolvers, SDKFilePresentationService.this.internalCall((Observable<Response<ResponseBody>>)((ISdkFilePresentationRService)SDKFilePresentationService.this.getService()).startFilePresentation(SDKFilePresentationService.this.getConferenceId(), body_sent)));
            }
        });
    }

    public Promise<FilePresentationUpdated> updatePresentation(final @NonNull String fileId, final int position) {
        return new Promise((PromiseSolver)new PromiseSolver<FilePresentationUpdated>(){

            public void onCall(@NonNull Solver<FilePresentationUpdated> solver) {
                ISdkFilePresentationRService.FilePresentationId body_sent = new ISdkFilePresentationRService.FilePresentationId(fileId, position);
                SDKFilePresentationService.this.consumeInternalCall(solver, fileId, SDKFilePresentationService.this.mCacheUpdatedSolvers, SDKFilePresentationService.this.internalCall((Observable<Response<ResponseBody>>)((ISdkFilePresentationRService)SDKFilePresentationService.this.getService()).startFilePresentation(SDKFilePresentationService.this.getConferenceId(), body_sent)));
            }
        });
    }
}

