/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.greenrobot.eventbus.EventBus;
import voxeet.com.sdk.core.VoxeetJsonError;
import voxeet.com.sdk.core.VoxeetSdkTemplate;
import voxeet.com.sdk.core.services.holder.ServiceProviderHolder;

public abstract class AbstractVoxeetService<T> {
    private static final String TAG = AbstractVoxeetService.class.getSimpleName();
    @NonNull
    private ServiceProviderHolder<T> holder = ServiceProviderHolder.DEFAULT;
    private Date lastUpdate = null;
    private boolean isLoaded = false;
    private int UPDATE_TIME = 300000;
    protected static final Handler handler = new Handler(Looper.getMainLooper());
    protected ExecutorService executorService = Executors.newSingleThreadExecutor();
    protected Context context;

    private AbstractVoxeetService() {
    }

    protected AbstractVoxeetService(@NonNull VoxeetSdkTemplate instance, @Nullable Class<T> service_klass) {
        this(instance, new ServiceProviderHolder.Builder().setClient(instance.getClient()).setRetrofit(instance.getRetrofit()).setService(service_klass).build());
    }

    protected AbstractVoxeetService(@NonNull VoxeetSdkTemplate instance, @NonNull ServiceProviderHolder<T> holder) {
        this();
        this.context = instance.getApplicationContext();
        this.holder = holder;
    }

    protected void updateTimeStamp() {
        this.lastUpdate = new Date();
    }

    protected boolean isLoaded() {
        return this.isLoaded;
    }

    protected void setLoaded(boolean loaded) {
        this.isLoaded = loaded;
    }

    protected boolean shouldUpdate() {
        if (this.lastUpdate == null) {
            return true;
        }
        return new Date().getTime() - this.lastUpdate.getTime() > (long)this.UPDATE_TIME;
    }

    protected final T getService() {
        return this.holder.getService();
    }

    protected String handleError(Throwable e) {
        Log.d((String)TAG, (String)("handleError: " + e.getClass().getSimpleName()));
        return e.getMessage();
    }

    protected static VoxeetJsonError getErrorBody(String message) {
        ObjectMapper om = new ObjectMapper();
        VoxeetJsonError command = null;
        try {
            command = (VoxeetJsonError)om.readValue(message, VoxeetJsonError.class);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"failed to get error body", (Throwable)e);
        }
        return command;
    }

    public void resetService() {
        this.lastUpdate = null;
        this.isLoaded = false;
    }

    @Nullable
    protected final String getURLRoot(@NonNull VoxeetSdkTemplate template) {
        return template.getVoxeetHttp().getBuiltServerUrl();
    }

    @Nullable
    protected final String getInternalToken(@NonNull VoxeetSdkTemplate template) {
        return template.getVoxeetHttp().getToken();
    }

    @Nullable
    protected final String getInternalJwtToken(@NonNull VoxeetSdkTemplate template) {
        return template.getVoxeetHttp().getJwtToken();
    }

    protected EventBus getEventBus() {
        return this.holder.getEventBus();
    }

    protected void registerEventBus() {
        EventBus eventBus = this.holder.getEventBus();
        if (!eventBus.isRegistered((Object)this)) {
            eventBus.register((Object)this);
        }
    }

    protected void unRegisterEventBus() {
        EventBus eventBus = this.holder.getEventBus();
        if (eventBus.isRegistered((Object)this)) {
            eventBus.unregister((Object)this);
        }
    }

    protected void postOnMainThread(@NonNull Runnable runnable) {
        handler.post(runnable);
    }
}

