/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.events.error;

import android.support.annotation.Nullable;
import android.util.Log;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;

public class HttpException
extends IOException {
    private Response response;

    private HttpException() {
    }

    public HttpException(Response response) {
        this();
        this.response = response;
    }

    @Nullable
    public Response getResponse() {
        return this.response;
    }

    public static HttpException throwResponse(Response response) {
        HttpException.dumpErrorResponse(response);
        try {
            throw new HttpException(response);
        }
        catch (HttpException e) {
            return e;
        }
    }

    public static <T> void dumpErrorResponse(@Nullable Response<T> response) {
        if (null == response) {
            Log.d((String)"HttpException", (String)"dumpErrorResponse: http call empty response :: network error");
            return;
        }
        ResponseBody body = response.errorBody();
        if (null != body) {
            try {
                String string2 = body.string();
                Log.d((String)"HttpException", (String)("dumpErrorResponse: http call exception := " + string2));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

