package voxeet.com.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.UNIQUE_URL)
public class UniqueUrl extends Event {
    private String nickName;

    private String email;

    public UniqueUrl(String email, String nickName) {
        this.email = email;

        this.nickName = nickName;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public String getType() {
        return EventNames.UNIQUE_URL;
    }
}
