package voxeet.com.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;

import java.util.List;

import voxeet.com.sdk.models.impl.DefaultMeeting;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.MEETING_ADDED_OR_UPDATED)
public class MeetingAddedOrUpdatedEvent extends Event {

    private List<DefaultMeeting> meetings;

    public List<DefaultMeeting> getMeetings() {
        return meetings;
    }

    public void setMeetings(List<DefaultMeeting> meetings) {
        this.meetings = meetings;
    }

    @Override
    public String getType() {
        return EventNames.MEETING_ADDED_OR_UPDATED;
    }
}
