package voxeet.com.sdk.core.services.holder;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import org.greenrobot.eventbus.EventBus;

import okhttp3.OkHttpClient;
import retrofit2.Retrofit;

/**
 * Created by kevinleperf on 11/07/2018.
 */

public class ServiceProviderHolder<RETROFIT_SERVICE_KLASS> {
    public final static ServiceProviderHolder DEFAULT = new ServiceProviderHolder();

    @Nullable
    protected OkHttpClient client;

    @NonNull
    protected EventBus eventBus;

    @Nullable
    protected Retrofit retrofit;

    @Nullable
    private RETROFIT_SERVICE_KLASS service;

    private ServiceProviderHolder() {
        eventBus = EventBus.getDefault();
    }

    private ServiceProviderHolder(@Nullable OkHttpClient client,
                                  @NonNull EventBus eventBus,
                                  @Nullable Retrofit retrofit,
                                  @Nullable RETROFIT_SERVICE_KLASS service) {
        this.client = client;
        this.eventBus = eventBus;
        this.retrofit = retrofit;
        this.service = service;
    }

    public OkHttpClient getClient() {
        return client;
    }

    public EventBus getEventBus() {
        return eventBus;
    }

    public Retrofit getRetrofit() {
        return retrofit;
    }

    public RETROFIT_SERVICE_KLASS getService() {
        return service;
    }

    public static class Builder<RETROFIT_SERVICE_KLASS> {
        @Nullable
        private OkHttpClient client;
        @NonNull
        private EventBus eventBus;
        @Nullable
        private Retrofit retrofit;
        @Nullable
        private Class<RETROFIT_SERVICE_KLASS> service;

        public Builder() {
            eventBus = EventBus.getDefault();
        }

        public Builder<RETROFIT_SERVICE_KLASS> setClient(@Nullable OkHttpClient client) {
            this.client = client;
            return this;
        }

        public Builder<RETROFIT_SERVICE_KLASS> setEventBus(@NonNull EventBus eventBus) {
            this.eventBus = eventBus;
            return this;
        }

        public Builder<RETROFIT_SERVICE_KLASS> setRetrofit(@Nullable Retrofit retrofit) {
            this.retrofit = retrofit;
            return this;
        }

        public Builder<RETROFIT_SERVICE_KLASS> setService(@Nullable Class<RETROFIT_SERVICE_KLASS> service) {
            this.service = service;
            return this;
        }

        public ServiceProviderHolder<RETROFIT_SERVICE_KLASS> build() {
            return new ServiceProviderHolder<>(
                    client,
                    eventBus,
                    retrofit,
                    (null != retrofit && null != service) ? retrofit.create(service) : null
            );
        }

    }

}
