/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.text.TextUtils;

public final class AndroidManifest {
    private AndroidManifest() {
    }

    public static int readMetadataInt(@NonNull Context context, @NonNull String key, int argb) {
        try {
            String metaData = AndroidManifest.readMetadata(context, key, null);
            if (!TextUtils.isEmpty((CharSequence)metaData)) {
                return Integer.parseInt(metaData);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return argb;
    }

    public static String readMetadata(@NonNull Context context, @NonNull String key, @NonNull String def) {
        ApplicationInfo appInfo = null;
        try {
            appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = appInfo.metaData;
            String value = bundle.getString(key);
            if (!TextUtils.isEmpty((CharSequence)value)) {
                return value;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return def;
    }
}

