package voxeet.com.sdk.core.services.localstats;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.util.Log;

import java.util.concurrent.locks.ReentrantLock;

public class LocalStatsHandler {
    private final static String TAG = LocalStatsHandler.class.getSimpleName();
    private long mLoop;
    private Runnable mCallback;
    private Handler mHandler;
    private ReentrantLock mLock;
    private LocalStatsRunnable mRunnable;
    private boolean mStopped;

    public LocalStatsHandler(@NonNull Runnable callback, long loop) {
        mCallback = callback;
        mStopped = true;
        mLoop = loop;
        mLock = new ReentrantLock();

        //TODO other looper ?
        mHandler = new Handler(Looper.getMainLooper());
    }

    public boolean startAutoFetch() {
        mLock.lock();
        if (null == mRunnable) {
            mRunnable = new LocalStatsRunnable() {
                @Override
                public void run() {
                    boolean post = false;
                    mLock.lock();
                    try {
                        mCallback.run();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }

                    LocalStatsRunnable instance = mRunnable;
                    if (null != instance && this.getToken() == instance.getToken()) {
                        post = true;
                    }
                    mLock.unlock();
                    Handler handler = mHandler;
                    if (null != handler) {
                        handler.removeCallbacks(this);

                        if (post && !mStopped) {
                            handler.postDelayed(this, mLoop);
                        }
                    }
                }
            };

            mStopped = false;
            mLock.unlock();
            mHandler.post(mRunnable);
            return true;
        } else {
            mLock.unlock();
            return false;
        }
    }

    public boolean stopAutoFetch() {
        mStopped = true;
        mLock.lock();
        if (null != mRunnable) {
            LocalStatsRunnable instance = mRunnable;
            mHandler.removeCallbacks(instance);
            mHandler = null;
            mRunnable = null;
            mLock.unlock();

            return true;
        } else {
            mLock.unlock();
            return false;
        }
    }
}
