/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.events.success;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import voxeet.com.sdk.json.Event;
import voxeet.com.sdk.json.UserInfo;
import voxeet.com.sdk.models.SdkParticipant;
import voxeet.com.sdk.models.impl.DefaultConferenceUser;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeName(value="ConferenceStatusUpdated")
public class ConferenceUpdated
extends Event {
    private String conferenceId;
    private String conferenceAlias;
    private boolean isLive;
    private long startTimestamp;
    private List<SdkParticipant> participants;

    public List<DefaultConferenceUser> getParticipants() {
        ArrayList<DefaultConferenceUser> users = new ArrayList<DefaultConferenceUser>();
        if (null != this.participants) {
            for (SdkParticipant participant : this.participants) {
                DefaultConferenceUser user = new DefaultConferenceUser(participant.getUserId(), null, new UserInfo(participant.getMetadata().getExternalName(), participant.getUserId(), participant.getMetadata().getExternalPhotoUrl()));
                user.setStatus(participant.getStatus());
                users.add(user);
            }
        }
        return users;
    }

    public String getConferenceId() {
        return this.conferenceId;
    }

    public void setConferenceId(String conferenceId) {
        this.conferenceId = conferenceId;
    }

    public String getConferenceAlias() {
        return this.conferenceAlias;
    }

    public void setConferenceAlias(String conferenceAlias) {
        this.conferenceAlias = conferenceAlias;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public void setStartTimestamp(long startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public boolean isLive() {
        return this.isLive;
    }

    public void setLive(boolean live) {
        this.isLive = live;
    }

    public void setParticipants(List<SdkParticipant> participants) {
        this.participants = participants;
    }

    public void setIsLive(boolean isLive) {
        this.isLive = isLive;
    }

    @Override
    public String getType() {
        return "ConferenceStatusUpdated";
    }
}

