package voxeet.com.sdk.events.promises;

import android.support.annotation.NonNull;

import voxeet.com.sdk.events.error.ConferenceJoinedError;

/**
 * Created by kevinleperf on 07/04/2018.
 */

public class PromiseConferenceJoinedErrorException extends Throwable {

    @NonNull
    private Throwable mException;

    @NonNull
    private ConferenceJoinedError mEvent;

    private PromiseConferenceJoinedErrorException() {

    }

    public PromiseConferenceJoinedErrorException(@NonNull ConferenceJoinedError event,
                                                 @NonNull Throwable exception) {
        this();

        mEvent = event;
        mException = exception;
    }

    public ConferenceJoinedError getEvent() {
        return mEvent;
    }

    public Throwable getException() {
        return mException;
    }
}
