/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.services.localstats;

import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.android.media.stats.LocalStats;
import com.voxeet.android.media.stats.RTCInboundRTPStreamStats;
import java.util.ArrayList;
import java.util.List;
import voxeet.com.sdk.core.services.localstats.TimePoint;

public class LocalStatsUserInfo {
    private static final long MAXIMUM_DIFFERENCE_MS = 50000L;
    private static final String TAG = LocalStatsUserInfo.class.getSimpleName();
    private String mUserId;
    private List<TimePoint> mPacketReceived;
    private List<TimePoint> mPacketSent;

    public LocalStatsUserInfo(String userId) {
        this.mUserId = userId;
        this.mPacketReceived = new ArrayList<TimePoint>();
        this.mPacketSent = new ArrayList<TimePoint>();
    }

    public void addFromLocalStats(@Nullable LocalStats stats) {
        if (null != stats) {
            List inbounds = stats.getStatsForClass(RTCInboundRTPStreamStats.class);
            for (RTCInboundRTPStreamStats inbound : inbounds) {
                Log.d((String)TAG, (String)("addFromLocalStats: " + this.mUserId + " :: " + inbound.toString()));
                if (!"audio".equals(inbound.mediaType)) continue;
            }
        }
    }

    public boolean isDisconnected() {
        return false;
    }

    public void purge() {
        this.removeInList(this.mPacketSent);
        this.removeInList(this.mPacketReceived);
    }

    private void removeInList(List<TimePoint> list) {
        int i = 0;
        long maximum_in_past = System.currentTimeMillis() - 50000L;
        while (i < list.size()) {
            if (list.get(i).getTime() < maximum_in_past) {
                list.remove(i);
                continue;
            }
            ++i;
        }
    }
}

