package voxeet.com.sdk.core.services.localstats;

import android.support.annotation.Nullable;
import android.util.Log;

import com.voxeet.android.media.stats.LocalStats;
import com.voxeet.android.media.stats.RTCInboundRTPStreamStats;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by kevinleperf on 31/10/2018.
 */

public class LocalStatsUserInfo {
    private final static long MAXIMUM_DIFFERENCE_MS = 50000;
    private static final String TAG = LocalStatsUserInfo.class.getSimpleName();
    private String mUserId;
    private List<TimePoint> mPacketReceived;
    private List<TimePoint> mPacketSent;

    public LocalStatsUserInfo(String userId) {
        this.mUserId = userId;
        mPacketReceived = new ArrayList<>();
        mPacketSent = new ArrayList<>();
    }

    public void addFromLocalStats(@Nullable LocalStats stats) {
        if(null != stats) {
            List<RTCInboundRTPStreamStats> inbounds = stats.getStatsForClass(RTCInboundRTPStreamStats.class);

            for (RTCInboundRTPStreamStats inbound : inbounds) {
                Log.d(TAG, "addFromLocalStats: " + mUserId + " :: " + inbound.toString());
                if ("audio".equals(inbound.mediaType)) {
                    //TODO add here
                }
            }
        } else {
            //TODO add -1 packet received
        }
    }

    public boolean isDisconnected() {
        return false;
    }

    public void purge() {
        removeInList(mPacketSent);
        removeInList(mPacketReceived);
    }

    private void removeInList(List<TimePoint> list) {
        //TODO optimize by using recycling list
        int i = 0;
        long maximum_in_past = System.currentTimeMillis() - MAXIMUM_DIFFERENCE_MS;
        while (i < list.size()) {
            if (list.get(i).getTime() < maximum_in_past) {
                list.remove(i);
            } else i++;
        }
    }
}
