package voxeet.com.sdk.core.services;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.android.media.MediaSDK;
import com.voxeet.android.media.stats.LocalStats;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

import voxeet.com.sdk.core.AbstractVoxeetService;
import voxeet.com.sdk.core.VoxeetSdkTemplate;
import voxeet.com.sdk.core.services.holder.ServiceProviderHolder;
import voxeet.com.sdk.core.services.localstats.LocalStatsHandler;
import voxeet.com.sdk.core.services.localstats.LocalStatsUserInfo;
import voxeet.com.sdk.models.impl.DefaultConference;
import voxeet.com.sdk.models.impl.DefaultConferenceUser;

public class LocalStatsService extends AbstractVoxeetService implements Runnable {
    public final static int NEXT_LOOP_FETCH_MS = 500;

    private ReentrantLock mLock;
    private VoxeetSdkTemplate mInstance;

    private LocalStatsHandler mHandler;
    private HashMap<String, LocalStatsUserInfo> mUserStatsHolder;

    public LocalStatsService(@NonNull VoxeetSdkTemplate instance) {
        super(instance, ServiceProviderHolder.DEFAULT);

        mUserStatsHolder = new HashMap<>();
        mHandler = null;
        mLock = new ReentrantLock();
        mInstance = instance;
    }

    @Nullable
    public LocalStats getLocalStats(@NonNull String peer) {
        MediaSDK media = mInstance.getMediaService().getMedia();
        if (null != media) return media.getLocalStats(peer);
        return null;
    }


    public boolean startAutoFetch() {
        if (null == mHandler) {
            mHandler = new LocalStatsHandler(this, NEXT_LOOP_FETCH_MS);
            mHandler.startAutoFetch();
            return true;
        } else {
            return false;
        }
    }

    public boolean stopAutoFetch() {
        if (null != mHandler) {
            mHandler.stopAutoFetch();
            mHandler = null;
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        //List<LocalStats> stats = new ArrayList<>();
        DefaultConference conference = mInstance.getConferenceService().getConference();

        if (null != conference) {
            List<DefaultConferenceUser> users = conference.getConferenceUsers();
            if (null != users) {
                for (int i = 0; i < users.size(); i++) {
                    DefaultConferenceUser user = users.get(i);
                    LocalStats stat = getLocalStats(user.getUserId());
                    getUserInfo(user.getUserId()).addFromLocalStats(stat);
                    /*if (null != stat) {
                        stats.add(stat);
                    }*/
                }
            }
        } else {
            //no conference ?
        }
    }

    private LocalStatsUserInfo getUserInfo(@NonNull String userId) {
        LocalStatsUserInfo info = mUserStatsHolder.get(userId);
        if (null == info) {
            info = new LocalStatsUserInfo(userId);
            mUserStatsHolder.put(userId, info);
        }
        return info;
    }
}
