package voxeet.com.sdk.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.text.TextUtils;

/**
 * Created by kevinleperf on 26/10/2018.
 */

public final class AndroidManifest {

    private AndroidManifest() {

    }

    public static int readMetadataInt(@NonNull Context context, @NonNull String key, int argb) {
        try {
            String metaData = readMetadata(context, key, null);
            if (!TextUtils.isEmpty(metaData)) return Integer.parseInt(metaData);
        } catch (Exception e) {

        }
        return argb;
    }

    public static String readMetadata(@NonNull Context context, @NonNull String key, @NonNull String def) {
        ApplicationInfo appInfo = null;
        try {
            appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(),
                    PackageManager.GET_META_DATA);
            Bundle bundle = appInfo.metaData;
            String value = bundle.getString(key);
            if (!TextUtils.isEmpty(value)) return value;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return def;
    }
}
