/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.services;

import android.content.Context;
import android.media.AudioManager;
import android.support.annotation.NonNull;
import com.voxeet.android.media.MediaPowerManager;
import com.voxeet.android.media.audio.AudioRoute;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import voxeet.com.sdk.core.AbstractVoxeetService;
import voxeet.com.sdk.core.VoxeetSdkTemplate;
import voxeet.com.sdk.core.services.holder.ServiceProviderHolder;
import voxeet.com.sdk.events.success.ConferencePreJoinedEvent;
import voxeet.com.sdk.json.ConferenceDestroyedPush;
import voxeet.com.sdk.utils.AudioType;
import voxeet.com.sdk.utils.SoundPool;
import voxeet.com.sdk.utils.Validate;

public class AudioService
extends AbstractVoxeetService {
    private final com.voxeet.android.media.audio.AudioManager mAudioManager;
    private final MediaPowerManager mMediaPowerManager;
    private final Context mContext;
    private final AudioManager mSystemAudioService;
    private final int mSoundMode;
    private int mSoundType = Integer.MIN_VALUE;
    private SoundPool _sound_pool;
    private HashMap<AudioType, String> mSounds;

    public AudioService(@NonNull VoxeetSdkTemplate instance) {
        super(instance, ServiceProviderHolder.DEFAULT);
        this.mSoundMode = 0;
        this.mAudioManager = new com.voxeet.android.media.audio.AudioManager(instance.getApplicationContext());
        this.mMediaPowerManager = new MediaPowerManager(instance.getApplicationContext(), this.currentRoute());
        this.mContext = instance.getApplicationContext();
        instance.getEventBus().register((Object)this);
        this.mSystemAudioService = (AudioManager)this.mContext.getSystemService("audio");
        this.mSounds = new HashMap();
        this.configure();
    }

    @NonNull
    public List<AudioRoute> getAvailableRoutes() {
        return this.mAudioManager.availableRoutes();
    }

    public AudioRoute currentRoute() {
        return this.mAudioManager.outputRoute();
    }

    public boolean setAudioRoute(@NonNull AudioRoute route) {
        Validate.runningOnUiThread();
        this.mAudioManager.setOutputRoute(route);
        return true;
    }

    public void setSpeakerMode(boolean isSpeaker) {
        this.mAudioManager.setSpeakerMode(isSpeaker);
    }

    public boolean isSpeakerOn() {
        return AudioRoute.ROUTE_SPEAKER.equals((Object)this.mAudioManager.outputRoute());
    }

    public void acquireLocks() {
        this.mMediaPowerManager.acquire();
    }

    public void releaseLocks() {
        this.mMediaPowerManager.release();
    }

    public void setInVoiceCallSoundType() {
        this.mAudioManager.forceVolumeControlStream(this.mSoundMode);
    }

    public void resetDefaultSoundType() {
        this.mAudioManager.forceVolumeControlStream(this.mAudioManager.getDefaultSoundStreamType());
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferencePreJoinedEvent event) {
        this.mSoundType = this.getUiSoundsStreamType();
        this.forceVolumeControlStream(this.mSoundMode);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceDestroyedPush event) {
        if (Integer.MIN_VALUE != this.mSoundType) {
            this.forceVolumeControlStream(this.mSoundType);
        }
    }

    private int getUiSoundsStreamType() {
        try {
            Method method = this.mSystemAudioService.getClass().getDeclaredMethod("getUiSoundsStreamType", new Class[0]);
            Object result = method.invoke((Object)this.mSystemAudioService, new Object[0]);
            return (Integer)result;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return 1;
    }

    private void forceVolumeControlStream(int type) {
        try {
            Method method = this.mSystemAudioService.getClass().getDeclaredMethod("forceVolumeControlStream", Integer.TYPE);
            method.invoke((Object)this.mSystemAudioService, type);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void abandonAudioFocusRequest() {
        this.mAudioManager.abandonAudioFocusRequest();
    }

    public void requestAudioFocus() {
        this.mAudioManager.requestAudioFocus();
    }

    private SoundPool getSoundPool() {
        if (this._sound_pool == null) {
            this._sound_pool = new SoundPool(this.mContext, this.mSoundMode);
        }
        return this._sound_pool;
    }

    private void configure() {
        this.mSounds.put(AudioType.RING, "out.mp3");
        this.mSounds.put(AudioType.HANGUP, "leave.mp3");
        this.setSound(AudioType.RING, this.mSounds.get((Object)AudioType.RING));
        this.setSound(AudioType.HANGUP, this.mSounds.get((Object)AudioType.HANGUP));
    }

    public boolean setSound(@NonNull AudioType type, @NonNull String assetName) {
        return this.getSoundPool().release(type).setShortResource(type, assetName);
    }

    public void playSoundType(@NonNull AudioType type) {
        this.getSoundPool().playShortResource(type, this.mSounds.get((Object)type));
    }

    public void stopSoundType(@NonNull AudioType audioType) {
        this.getSoundPool().stop(audioType);
    }

    public void stop() {
        this.getSoundPool().stop();
    }
}

