/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.services;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.Solver;
import org.greenrobot.eventbus.EventBus;
import voxeet.com.sdk.core.abs.AbstractConferenceSdkService;
import voxeet.com.sdk.events.ConferenceTimeoutUserJoinedEvent;
import voxeet.com.sdk.utils.Twig;

public class TimeoutRunnable
implements Runnable {
    private static final String TAG = TimeoutRunnable.class.getSimpleName();
    private long mTimeout;
    @NonNull
    private EventBus mEventBus;
    @NonNull
    private Twig mLogger;
    @NonNull
    private AbstractConferenceSdkService mService;
    private boolean mCanceled;
    private boolean mTriggered;

    private TimeoutRunnable() {
        this.setCanceled(false);
        this.mTriggered = false;
    }

    public TimeoutRunnable(@NonNull AbstractConferenceSdkService service, @NonNull Twig logger, @NonNull EventBus event_bus, long timeout) {
        this();
        this.mService = service;
        this.mLogger = logger;
        this.mEventBus = event_bus;
        this.mTimeout = timeout;
    }

    public void setCanceled(boolean canceled) {
        this.mCanceled = canceled;
    }

    public boolean isCanceled() {
        return this.mCanceled;
    }

    @Override
    public void run() {
        if (!this.isCanceled()) {
            this.mLogger.i("No conference user joined after " + this.mTimeout + "ms. Now Attempting to leave the conference", new Object[0]);
            this.mService.leave().then(new PromiseExec(){

                public void onCall(@Nullable Object o, @NonNull Solver solver) {
                }
            }).error(new ErrorPromise(){

                public void onError(Throwable error) {
                    error.printStackTrace();
                }
            });
            this.mEventBus.post((Object)new ConferenceTimeoutUserJoinedEvent(this.mTimeout));
            this.mTriggered = true;
        }
    }

    public boolean isTriggered() {
        return this.mTriggered;
    }
}

