package voxeet.com.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;

@JsonTypeName(EventNames.BROADCAST_EVENT)
@JsonIgnoreProperties(ignoreUnknown = true)
public class BroadcastEvent extends Event {

    @JsonProperty("message")
    private String message;

    @JsonProperty("from")
    private String userId;

    private String meetingId;

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getMeetingId() {
        return meetingId;
    }

    public void setMeetingId(String meetingId) {
        this.meetingId = meetingId;
    }

    public BroadcastEvent() {
    }

    public BroadcastEvent(String message) {
        this.message = message;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String getType() {
        return EventNames.BROADCAST_EVENT;
    }
}
