package voxeet.com.sdk.events.success;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import voxeet.com.sdk.events.SuccessEvent;

@JsonIgnoreProperties(ignoreUnknown = true)
public class StartScreenShareAnswerEvent extends SuccessEvent {

    private boolean mIsSuccess;
    private boolean mIsAlreadyStarted;

    public StartScreenShareAnswerEvent(boolean isSuccessful, boolean already_started) {
        mIsSuccess = isSuccessful;
        mIsAlreadyStarted = already_started;
    }

    public StartScreenShareAnswerEvent(boolean isSuccessful) {
        this(isSuccessful, false);
    }

    public StartScreenShareAnswerEvent(boolean isSuccessful, String error) {
        super(error);

        this.mIsSuccess = isSuccessful;
    }

    public boolean isAlreadyStarted() {
        return mIsAlreadyStarted;
    }

    public boolean isSuccess() {
        return mIsSuccess;
    }

    public void setSuccess(boolean success) {
        this.mIsSuccess = success;
    }
}
