package voxeet.com.sdk.core;

import android.support.annotation.NonNull;

import voxeet.com.sdk.core.preferences.VoxeetPreferences;
import voxeet.com.sdk.utils.Validate;

/**
 * Created by kevinleperf on 09/11/2017.
 */

public class VoxeetSdkFactory {

    private VoxeetSdkFactory() {
        super();
    }

    /**
     * This function validate the SDK Instance and init its behaviour.
     *
     * @param sdk_template The SDK Instance to validate
     */
    protected static synchronized void validate(@NonNull VoxeetSdkTemplate sdk_template) {

        Validate.hasInternetPermissions(sdk_template.getApplicationContext(), true);
        VoxeetPreferences.init(sdk_template.getApplicationContext());
    }
}
