package voxeet.com.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
public class SdkConferenceInvitation {

    @JsonProperty("voxeetIds")
    private List<String> voxeetIds;

    @JsonProperty("externalIds")
    private List<String> externalIds;

    public SdkConferenceInvitation() {
    }

    public SdkConferenceInvitation(List<String> voxeetIds, List<String> externalIds) {
        this.voxeetIds = voxeetIds;
        this.externalIds = externalIds;
    }

    public List<String> getVoxeetIds() {
        return voxeetIds;
    }

    public void setVoxeetIds(List<String> voxeetIds) {
        this.voxeetIds = voxeetIds;
    }

    public List<String> getExternalIds() {
        return externalIds;
    }

    public void setExternalIds(List<String> externalIds) {
        this.externalIds = externalIds;
    }
}