package voxeet.com.sdk.json.internal;

import android.support.annotation.NonNull;

import java.util.HashMap;

/**
 * Created by kevinleperf on 19/04/2018.
 */

public class MetadataHolder {

    private HashMap<String, Object> values;

    public MetadataHolder() {
        values = new HashMap<>();

        setStats(false).isLiveRecording(false);
    }

    public MetadataHolder(HashMap<String, Object> values) {
        this.values = values;
    }

    public MetadataHolder setStats(boolean stats) {
        putValue("stats", stats);
        return this;
    }

    public MetadataHolder isLiveRecording(boolean liveRecording) {
        putValue("liveRecording", liveRecording);
        return this;
    }

    public MetadataHolder putValue(@NonNull String key, Object value) {
        values.put(key, value);
        return this;
    }

    public HashMap<String, Object> build() {
        return values;
    }
}
