package voxeet.com.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;

import java.util.List;

import voxeet.com.sdk.models.impl.DefaultFile;

/**
 * Created by RomainB on 5/25/16.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.FILE_CONVERTED)
public class FileConverted extends Event {
    private List<DefaultFile> files;

    private String errorMessage;

    public List<DefaultFile> getFiles() {
        return files;
    }

    public void setFiles(List<DefaultFile> files) {
        this.files = files;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    @Override
    public String getType() {
        return EventNames.FILE_CONVERTED;
    }

    public boolean isSuccess() {
        return CONVERSION_SUCCEEDED.equals(errorMessage);
    }

    public static String CONVERSION_SUCCEEDED = "CONVERSION_SUCCEDED";
}
