package voxeet.com.sdk.core.network;

import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import rx.Observable;
import voxeet.com.sdk.events.success.GetTokenUploadSuccessEvent;
import voxeet.com.sdk.events.success.GetUserProfileSuccessEvent;
import voxeet.com.sdk.events.success.LoginSuccessResponseEvent;
import voxeet.com.sdk.events.success.OwnProfileSuccessEvent;
import voxeet.com.sdk.json.EmailEvent;
import voxeet.com.sdk.json.LoginEvent;
import voxeet.com.sdk.json.ResendActivationEvent;
import voxeet.com.sdk.json.ResetPasswordEvent;
import voxeet.com.sdk.json.SignUpEvent;
import voxeet.com.sdk.json.SocialLoginEvent;
import voxeet.com.sdk.json.UpdatePasswordEvent;
import voxeet.com.sdk.json.UpdatePresenceEvent;
import voxeet.com.sdk.json.UpdateProfileEvent;

/**
 * Created by ROMMM on 4/4/16.
 */
public interface IUserRService {

    @POST("users/login")
    Observable<LoginSuccessResponseEvent> login(@Body LoginEvent loginEvent);

    @POST("mobile/loginValidated")
    Observable<LoginSuccessResponseEvent> socialLogin(@Body SocialLoginEvent loginEvent);

    @POST("users/logout")
    Observable<Response<ResponseBody>> logout();

    @POST("users/resetPassword")
    Observable<Response<ResponseBody>> resetPassword(@Body ResetPasswordEvent event);

    @POST("users/create")
    Observable<Response<ResponseBody>> signup(@Body SignUpEvent event);

    @PUT("users/me")
    Observable<Response<ResponseBody>> updateProfile(@Body UpdateProfileEvent event);

    @PUT("users/me/updatePresence")
    Observable<Response<ResponseBody>> updatePresence(@Body UpdatePresenceEvent event);

    @GET("users/me")
    @Headers("Content-Type: application/json")
    Observable<OwnProfileSuccessEvent> getOwnProfile();

    @GET("users/me/getUploadToken")
    @Headers("Content-Type: application/json")
    Observable<GetTokenUploadSuccessEvent> getUploadToken();

    @GET("users/{userId}")
    Observable<GetUserProfileSuccessEvent> getUserProfile(@Path("userId") String userId);

    @POST("users/resendActivation")
    Observable<Response<ResponseBody>> resendActivation(@Body ResendActivationEvent event);

    @POST("users/resendValidation")
    Observable<Response<ResponseBody>> resendValidation(@Body ResendActivationEvent event);

    @PUT("users/me/addEmail")
    Observable<Response<ResponseBody>> addEmail(@Body EmailEvent event);

    @PUT("users/me/removeEmail")
    Observable<Response<ResponseBody>> removeEmail(@Body EmailEvent event);

    @PUT("users/me/setDefaultEmail")
    Observable<Response<ResponseBody>> setDefaultEmail(@Body EmailEvent event);

    @PUT("/users/me/updatePassword")
    Observable<Response<ResponseBody>> updatePassword(@Body UpdatePasswordEvent event);
}