/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.ContentResolver;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.firebase.iid.FirebaseInstanceId;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Retrofit;
import voxeet.com.sdk.converter.JacksonConverterFactory;
import voxeet.com.sdk.core.FirebaseController;
import voxeet.com.sdk.core.VoxeetSdkTemplate;
import voxeet.com.sdk.core.http.RefreshTokenBody;
import voxeet.com.sdk.core.network.IVoxeetRService;
import voxeet.com.sdk.core.preferences.VoxeetPreferences;
import voxeet.com.sdk.json.GrandTypeEvent;
import voxeet.com.sdk.json.UserInfo;
import voxeet.com.sdk.models.TokenResponse;
import voxeet.com.sdk.models.UserTokenResponse;
import voxeet.com.sdk.networking.DeviceType;
import voxeet.com.sdk.utils.Auth64;

public class VoxeetHttp {
    private static final String TAG = VoxeetHttp.class.getSimpleName();
    private static final String HEADER_NAME_AUTHORIZATION = "Authorization";
    private static final String HEADER_NAME_XTOKEN = "X-Token";
    private final VoxeetSdkTemplate sdk;
    @NonNull
    private IVoxeetRService service;
    @Nullable
    private final String appId;
    @Nullable
    private final String password;
    @Nullable
    private final String tokenAccess;
    @Nullable
    private final Callable<String> tokenRefresh;
    @Nullable
    private TokenResponse tokenResponse;
    private Application appContext;
    private String serverUrl;
    private String serverPort;
    public Retrofit retrofit;
    private OkHttpClient client;
    private TokenResponseProvider tokenResponseProvider;
    private VoxeetServiceListener listener;
    private boolean debug = false;
    private final HashMap<String, List<Cookie>> cookieStore = new HashMap();
    private UserTokenResponse mUserTokenResponse;
    private UserInfo mUserInfo;
    private String TOKEN_RESET = "";
    private boolean isAuthenticating = false;
    private OkHttpClient clientIdentify;
    private Retrofit retrofitIdentify;

    private VoxeetHttp(Application appContext, VoxeetSdkTemplate sdk, String serverUrl, String serverPort, String appId, String password, VoxeetServiceListener listener, String tokenAccess, final Callable<String> tokenRefresh, boolean debug) {
        this.sdk = sdk;
        this.tokenResponse = null;
        this.serverUrl = serverUrl;
        this.serverPort = serverPort;
        this.appContext = appContext;
        this.tokenAccess = tokenAccess;
        this.tokenRefresh = tokenRefresh;
        this.debug = debug;
        this.listener = listener;
        this.appId = appId;
        this.password = password;
        this.initClient();
        this.initRetrofit();
        this.initService();
        if (null != appId && null != password) {
            Log.d((String)TAG, (String)"VoxeetHttp: initializing using appId/password");
            this.tokenResponseProvider = new TokenResponseProvider(){

                @Override
                @Nullable
                public TokenResponse refreshTokenResponse() {
                    Log.d((String)TAG, (String)"refreshTokenResponse: calling refreshing token");
                    TokenResponse previous = VoxeetHttp.this.tokenResponse;
                    TokenResponse new_token_response = null;
                    Call<TokenResponse> token = null;
                    String tokenizedCredentials = Auth64.serialize(VoxeetHttp.this.appId, VoxeetHttp.this.password);
                    try {
                        if (null != previous && null != previous.getRefreshToken()) {
                            token = VoxeetHttp.this.service.refreshToken(tokenizedCredentials, new RefreshTokenBody(previous.getRefreshToken()));
                        }
                        if (null != token) {
                            new_token_response = (TokenResponse)token.execute().body();
                        }
                    }
                    catch (Exception e) {
                        Log.d((String)TAG, (String)("authenticate: error on refresh token " + e.getMessage()));
                        e.printStackTrace();
                    }
                    if (null != new_token_response && null != new_token_response.getAccessToken()) {
                        return new_token_response;
                    }
                    try {
                        token = VoxeetHttp.this.service.getToken(tokenizedCredentials, new GrandTypeEvent("client_credentials"));
                        return (TokenResponse)token.execute().body();
                    }
                    catch (Exception e) {
                        Log.d((String)TAG, (String)"refreshTokenResponse: second token attempt error");
                        e.printStackTrace();
                        return null;
                    }
                }
            };
        } else if (null != tokenAccess && null != tokenRefresh) {
            Log.d((String)TAG, (String)"VoxeetHttp: initializing using access/refresh");
            this.tokenResponse = new TokenResponse(tokenAccess, null);
            this.tokenResponseProvider = new TokenResponseProvider(){

                @Override
                @Nullable
                public TokenResponse refreshTokenResponse() {
                    try {
                        String tokenAccess = (String)tokenRefresh.call();
                        return new TokenResponse(tokenAccess, null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            };
        }
    }

    private void initClient() {
        HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor();
        interceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        CookieJar cookieJar = new CookieJar(){

            public void saveFromResponse(HttpUrl url, List<Cookie> cookies) {
                String base = url.scheme() + "://" + url.host() + ":" + url.port();
                VoxeetHttp.this.cookieStore.put(base, Lists.newArrayList((Iterable)Iterables.filter(cookies, (Predicate)new Predicate<Cookie>(){

                    public boolean apply(Cookie input) {
                        return input != null && !input.value().equalsIgnoreCase("deleted") && new Date().before(new Date(input.expiresAt()));
                    }
                })));
            }

            public List<Cookie> loadForRequest(HttpUrl url) {
                String base = url.scheme() + "://" + url.host() + ":" + url.port();
                List cookies = (List)VoxeetHttp.this.cookieStore.get(base);
                return cookies != null ? cookies : new ArrayList();
            }
        };
        OkHttpClient.Builder builderIdentify = new OkHttpClient.Builder().cookieJar(cookieJar).addNetworkInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request.Builder builder = chain.request().newBuilder();
                if (null != VoxeetHttp.this.tokenResponse) {
                    builder.removeHeader(VoxeetHttp.HEADER_NAME_AUTHORIZATION).addHeader(VoxeetHttp.HEADER_NAME_AUTHORIZATION, Auth64.serialize(VoxeetHttp.this.appId, VoxeetHttp.this.password)).addHeader(VoxeetHttp.HEADER_NAME_AUTHORIZATION, "bearer " + VoxeetHttp.this.TOKEN_RESET + VoxeetHttp.this.tokenResponse.getAccessToken());
                }
                return chain.proceed(builder.build());
            }
        }).authenticator(new Authenticator(){

            public Request authenticate(Route route, Response response) throws IOException {
                return VoxeetHttp.this.reauthenticate(route, response);
            }
        }).connectionPool(new ConnectionPool(5, 45L, TimeUnit.SECONDS)).retryOnConnectionFailure(true).readTimeout(5L, TimeUnit.SECONDS).writeTimeout(5L, TimeUnit.SECONDS);
        OkHttpClient.Builder builder = new OkHttpClient.Builder().cookieJar(cookieJar).addNetworkInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Log.d((String)TAG, (String)"intercept: ----------------------------");
                try {
                    return VoxeetHttp.this.execute(chain);
                }
                catch (Exception exception) {
                    Log.d((String)TAG, (String)"intercept: executing failed time");
                    if (exception instanceof IOException) {
                        throw exception;
                    }
                    Request.Builder builder = chain.request().newBuilder();
                    return chain.proceed(builder.build());
                }
            }
        }).authenticator(new Authenticator(){

            public Request authenticate(Route route, Response response) throws IOException {
                Log.d((String)TAG, (String)"authenticate: reauthenticating");
                return VoxeetHttp.this.reauthenticate(route, response);
            }
        }).connectionPool(new ConnectionPool(5, 45L, TimeUnit.SECONDS)).retryOnConnectionFailure(true).readTimeout(5L, TimeUnit.SECONDS).writeTimeout(5L, TimeUnit.SECONDS);
        if (this.debug) {
            builder = builder.hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            builder = builder.addInterceptor((Interceptor)interceptor);
            builderIdentify = builderIdentify.addInterceptor((Interceptor)interceptor);
        }
        this.client = builder.build();
        this.clientIdentify = builderIdentify.build();
    }

    private void initRetrofit() {
        this.retrofit = new Retrofit.Builder().addConverterFactory((Converter.Factory)JacksonConverterFactory.create(new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES))).baseUrl(this.getBuiltServerUrl()).client(this.client).build();
        this.retrofitIdentify = new Retrofit.Builder().addConverterFactory((Converter.Factory)JacksonConverterFactory.create(new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES))).baseUrl(this.getBuiltServerUrl()).client(this.clientIdentify).build();
    }

    private void initService() {
        this.service = (IVoxeetRService)this.retrofitIdentify.create(IVoxeetRService.class);
    }

    @SuppressLint(value={"HardwareIds"})
    void identify(UserInfo userInfo) {
        this.identifyChain(userInfo).then((PromiseExec)new PromiseExec<Boolean, Object>(){

            public void onCall(@Nullable Boolean result, @NonNull Solver<Object> solver) {
                Log.d((String)TAG, (String)("onCall: identify finished " + result));
            }
        }).error(new ErrorPromise(){

            public void onError(@NonNull Throwable error) {
                error.printStackTrace();
            }
        });
    }

    Promise<Boolean> identifyChain(final UserInfo userInfo) {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(final @NonNull Solver<Boolean> final_solver) {
                VoxeetHttp.this.mUserInfo = userInfo;
                userInfo.setDeviceIdentifier(Settings.Secure.getString((ContentResolver)VoxeetHttp.this.appContext.getContentResolver(), (String)"android_id"));
                if (FirebaseController.getInstance().isTokenUploadAllowed()) {
                    String token = FirebaseController.getInstance().getToken();
                    if (token != null) {
                        VoxeetHttp.this.sdk.getTwig().i("FirebaseInstanceId.getInstance().getAccessToken(): " + FirebaseInstanceId.getInstance().getToken(), new Object[0]);
                        userInfo.setDevicePushToken(token);
                    } else {
                        VoxeetHttp.this.sdk.getTwig().e("FirebaseInstanceId.getInstance().getAccessToken() returned an IllegalStateException, you have an issue with your project configuration (google-services.json for instance)", new Object[0]);
                    }
                } else {
                    VoxeetHttp.this.sdk.getTwig().i("FirebaseApp is not initialized. Make sure to call FirebaseApp.initializeApp(Context) before initializing the VoxeetSDK if you are planning on using FCM.", new Object[0]);
                }
                userInfo.setDeviceType(DeviceType.ANDROID);
                VoxeetHttp.this.retrieveTokenResponse().then((PromiseExec)new PromiseExec<TokenResponse, UserTokenResponse>(){

                    public void onCall(@Nullable TokenResponse result, @NonNull Solver<UserTokenResponse> solver) {
                        VoxeetHttp.this.sdk.getTwig().i("validated access with the servers ; authenticating user... " + result, new Object[0]);
                        VoxeetHttp.this.tokenResponse = result;
                        solver.resolve(VoxeetHttp.this.retrieveUserTokenResponse(userInfo));
                    }
                }).then((PromiseExec)new PromiseExec<UserTokenResponse, Object>(){

                    public void onCall(@Nullable UserTokenResponse result, @NonNull Solver<Object> solver) {
                        VoxeetHttp.this.mUserTokenResponse = result;
                        VoxeetHttp.this.sdk.getTwig().i("Successful login with id " + result.getId(), new Object[0]);
                        VoxeetPreferences.setId(result.getId());
                        VoxeetPreferences.saveLoginCookie(result.getUserToken());
                        VoxeetHttp.this.listener.onIdentifySuccess(result, VoxeetHttp.this.tokenResponse);
                        List cookies = VoxeetHttp.this.getCookies(VoxeetHttp.this.getBuiltServerUrl());
                        if (cookies != null && cookies.size() > 0) {
                            VoxeetPreferences.saveLoginCookie(((Cookie)cookies.get(0)).toString());
                        }
                        final_solver.resolve((Object)true);
                    }
                }).error(new ErrorPromise(){

                    public void onError(@NonNull Throwable error) {
                        error.printStackTrace();
                        if (error instanceof UnknownHostException) {
                            VoxeetHttp.this.listener.onNetworkError((UnknownHostException)error);
                        } else {
                            VoxeetHttp.this.listener.onIdentifyError(error.getMessage());
                        }
                        final_solver.reject(error);
                    }
                });
            }
        });
    }

    private List<Cookie> getCookies(String url) {
        for (Map.Entry<String, List<Cookie>> o : this.cookieStore.entrySet()) {
            Map.Entry<String, List<Cookie>> pair = o;
            if (!pair.getKey().contains(url)) continue;
            return this.cookieStore.get(pair.getKey());
        }
        return null;
    }

    private String createCookie(String value) {
        String url = this.getBuiltServerUrl();
        Cookie cookie = Cookie.parse((HttpUrl)HttpUrl.parse((String)url), (String)value);
        if (cookie != null && cookie.toString().length() > 0) {
            this.cookieStore.put(url, Collections.singletonList(cookie));
            return cookie.value();
        }
        return null;
    }

    public OkHttpClient getClient() {
        return this.client;
    }

    public String retrieveCookie() {
        String cookie = VoxeetPreferences.getLoginCookie();
        if (cookie != null && cookie.length() > 0) {
            cookie = this.createCookie(cookie);
        } else {
            List<Cookie> cookies = this.getCookies(this.getBuiltServerUrl());
            if (cookies != null && cookies.size() > 0) {
                cookie = cookies.get(0).value();
                VoxeetPreferences.saveLoginCookie(cookies.get(0).toString());
            }
        }
        return cookie;
    }

    Retrofit getRetrofit() {
        return this.retrofit;
    }

    String getToken() {
        return this.mUserTokenResponse != null ? this.mUserTokenResponse.getUserToken() : null;
    }

    String getJwtToken() {
        return this.mUserTokenResponse != null ? this.mUserTokenResponse.getJwtUserToken() : null;
    }

    String getBuiltServerUrl() {
        String port = this.serverPort;
        if (!port.startsWith(":")) {
            port = ":" + port;
        }
        return this.serverUrl + port;
    }

    @NonNull
    private Promise<TokenResponse> retrieveTokenResponse() {
        return new Promise((PromiseSolver)new PromiseSolver<TokenResponse>(){

            public void onCall(final @NonNull Solver<TokenResponse> solver) {
                if (null != VoxeetHttp.this.tokenAccess && null != VoxeetHttp.this.tokenRefresh) {
                    solver.resolve((Object)new TokenResponse(VoxeetHttp.this.tokenAccess, null));
                } else if (null != VoxeetHttp.this.appId && null != VoxeetHttp.this.password) {
                    Call<TokenResponse> token = VoxeetHttp.this.service.getToken(Auth64.serialize(VoxeetHttp.this.appId, VoxeetHttp.this.password), new GrandTypeEvent("client_credentials"));
                    token.enqueue((Callback)new Callback<TokenResponse>(){

                        public void onResponse(Call<TokenResponse> call, retrofit2.Response<TokenResponse> response) {
                            Log.d((String)TAG, (String)("onResponse: " + response.body()));
                            solver.resolve(response.body());
                        }

                        public void onFailure(Call<TokenResponse> call, Throwable t) {
                            Log.d((String)TAG, (String)("onFailure: " + t));
                            t.printStackTrace();
                            solver.reject(t);
                        }
                    });
                } else {
                    try {
                        throw new Exception("Invalid mode, issue with SDK compilation?");
                    }
                    catch (Exception e) {
                        solver.reject((Throwable)e);
                    }
                }
            }
        });
    }

    @NonNull
    private Promise<UserTokenResponse> retrieveUserTokenResponse(final @NonNull UserInfo userInfo) {
        return new Promise((PromiseSolver)new PromiseSolver<UserTokenResponse>(){

            public void onCall(final @NonNull Solver<UserTokenResponse> solver) {
                Call<UserTokenResponse> user = VoxeetHttp.this.service.identify(userInfo);
                user.enqueue((Callback)new Callback<UserTokenResponse>(){

                    public void onResponse(Call<UserTokenResponse> call, retrofit2.Response<UserTokenResponse> response) {
                        solver.resolve(response.body());
                    }

                    public void onFailure(Call<UserTokenResponse> call, Throwable t) {
                        solver.reject(t);
                    }
                });
            }
        });
    }

    public void FORCE_TOKEN_RESET() {
        this.TOKEN_RESET = "resetting";
    }

    @Nullable
    private Response execute(Interceptor.Chain chain) throws IOException {
        try {
            Request.Builder builder = chain.request().newBuilder();
            if (null != this.tokenResponse) {
                builder.addHeader(HEADER_NAME_AUTHORIZATION, "bearer " + this.TOKEN_RESET + this.tokenResponse.getAccessToken());
            }
            if (null != this.mUserTokenResponse) {
                builder.removeHeader(HEADER_NAME_XTOKEN).addHeader(HEADER_NAME_XTOKEN, this.mUserTokenResponse.getJwtUserToken());
            }
            return chain.proceed(builder.build());
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("execute: ISSUE WHILE EXECUTING " + chain.call().request().toString()));
            if (e instanceof IOException) {
                throw e;
            }
            e.printStackTrace();
            return null;
        }
    }

    private Request reauthenticate(Route route, Response response) {
        this.isAuthenticating = true;
        this.TOKEN_RESET = "";
        Request.Builder builder = response.request().newBuilder();
        TokenResponse tokenResponse = this.tokenResponseProvider.refreshTokenResponse();
        if (null == tokenResponse) {
            this.isAuthenticating = false;
            throw new IllegalStateException("Invalid credentials");
        }
        this.tokenResponse = tokenResponse;
        if (null != this.mUserInfo && null == this.mUserTokenResponse) {
            try {
                UserTokenResponse userTokenResponse = (UserTokenResponse)this.service.identify(this.mUserInfo).execute().body();
                if (null != userTokenResponse) {
                    this.mUserTokenResponse = userTokenResponse;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (null != tokenResponse) {
            builder.removeHeader(HEADER_NAME_AUTHORIZATION).addHeader(HEADER_NAME_AUTHORIZATION, Auth64.serialize(this.appId, this.password)).addHeader(HEADER_NAME_AUTHORIZATION, "bearer " + tokenResponse.getAccessToken());
        }
        if (null != this.mUserTokenResponse) {
            builder.removeHeader(HEADER_NAME_XTOKEN).addHeader(HEADER_NAME_XTOKEN, this.mUserTokenResponse.getJwtUserToken());
        } else {
            Log.d((String)TAG, (String)"authenticate: no jwt token");
        }
        this.isAuthenticating = false;
        return builder.build();
    }

    private static interface TokenResponseProvider {
        @Nullable
        public TokenResponse refreshTokenResponse();
    }

    public static final class Builder {
        private Application _application;
        private VoxeetSdkTemplate _sdk;
        private String _server_url;
        private String _server_port;
        private String _app_id;
        private String _password;
        private String _tokenAccess;
        private Callable<String> _tokenRefresh;
        private VoxeetServiceListener _listener;
        private boolean _debug;

        public Builder setApplication(Application application) {
            this._application = application;
            return this;
        }

        public Builder setVoxeetSDK(VoxeetSdkTemplate sdk) {
            this._sdk = sdk;
            return this;
        }

        public Builder setServerUrl(String serverUrl) {
            this._server_url = serverUrl;
            return this;
        }

        public Builder setServerPort(String serverPort) {
            this._server_port = serverPort;
            return this;
        }

        public Builder setAppId(String appId) {
            this._app_id = appId;
            return this;
        }

        public Builder setPassword(String password) {
            this._password = password;
            return this;
        }

        public Builder setVoxeetServiceListener(VoxeetServiceListener listener) {
            this._listener = listener;
            return this;
        }

        public Builder setDebug(boolean debug) {
            this._debug = debug;
            return this;
        }

        public Builder setTokenAccess(String tokenAccess) {
            this._tokenAccess = tokenAccess;
            return this;
        }

        public Builder setTokenRefresh(Callable<String> tokenRefresh) {
            this._tokenRefresh = tokenRefresh;
            return this;
        }

        public VoxeetHttp build() {
            return new VoxeetHttp(this._application, this._sdk, this._server_url, this._server_port, this._app_id, this._password, this._listener, this._tokenAccess, this._tokenRefresh, this._debug);
        }
    }

    public static interface VoxeetServiceListener {
        public void onIdentifySuccess(UserTokenResponse var1, TokenResponse var2);

        public void onIdentifyError(String var1);

        public void onNetworkError(UnknownHostException var1);
    }
}

