package voxeet.com.sdk.events.error;

import voxeet.com.sdk.events.ErrorEvent;

/**
 * Simple class sent through the app with the result from the
 * subscription on a specific conference id/alias (to be invited
 * when it starts)
 */
public class UnsubscribeFromCallConferenceErrorEvent extends ErrorEvent {

    private String conferenceId;

    public UnsubscribeFromCallConferenceErrorEvent(String conferenceId, String message) {
        super(message);

        this.conferenceId = conferenceId;
    }

    public String getConferenceId() {
        return conferenceId;
    }
}
