package voxeet.com.sdk.utils;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;

import java.security.MessageDigest;

public class Sha1 {
    public static String compute(String password) {
        try {
            final MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(password.getBytes("utf-8"));

            return Hashing.sha1().hashString(password, Charsets.UTF_8).toString();
        } catch (Throwable e) {
            return null;
        }
    }
}
