package voxeet.com.sdk.json;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import voxeet.com.sdk.json.internal.MetadataHolder;

/**
 * Created by kevinleperf on 19/04/2018.
 */

public class CreateConferenceParams {

    @Nullable
    public String conferenceId;

    //the conference conferenceAlias if any
    @Nullable
    public String conferenceAlias;

    public MetadataHolder metadata;

    public CreateConferenceParams() {
        metadata = new MetadataHolder();
    }

    public CreateConferenceParams(boolean stats) {
        this();

        metadata.setStats(stats);
    }

    @NonNull
    public CreateConferenceParams setStats(boolean stats) {
        metadata.setStats(stats);
        return this;
    }

    @NonNull
    public CreateConferenceParams setConferenceAlias(@Nullable String alias) {
        conferenceAlias = alias;
        return this;
    }

    @NonNull
    public CreateConferenceParams setConferenceId(@Nullable String id) {
        conferenceId = id;
        return this;
    }
}
