package voxeet.com.sdk.models;

import com.voxeet.android.media.SdpCandidate;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by kevinleperf on 24/09/2018.
 */

public class CandidatesPush {

    public String commandType = "CandidatesGatheredCommand";

    public List<SdpCandidateRest> candidates;

    public CandidatesPush() {

    }

    public CandidatesPush(SdpCandidate[] candidates) {
        this.candidates = new ArrayList<>();
        for (SdpCandidate candidate : candidates) {
            this.candidates.add(new SdpCandidateRest(candidate));
        }
    }

    public CandidatesPush(List<SdpCandidate> candidates) {
        this.candidates = new ArrayList<>();
        for (SdpCandidate candidate : candidates) {
            this.candidates.add(new SdpCandidateRest(candidate));
        }
    }

    public static class SdpCandidateRest {

        public int sdpMLineIndex;
        public String sdp;
        public String sdpMid;

        public SdpCandidateRest() {

        }

        public SdpCandidateRest(int sdpMLineIndex, String sdp, String sdpMid) {
            this.sdpMLineIndex = sdpMLineIndex;
            this.sdp = sdp;
            this.sdpMid = sdpMid;
        }

        public SdpCandidateRest(SdpCandidate candidate) {
            this(candidate.getSdpMLineIndex(), candidate.getSdp(), candidate.getSdpMid());
        }
    }
}
