package voxeet.com.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.UPDATE_PRESENCE)
public class UpdatePresenceEvent extends Event {

    private String userId;

    private String presenceStatus;

    public UpdatePresenceEvent(String userId, String presenceStatus) {

        this.userId = userId;

        this.presenceStatus = presenceStatus;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPresenceStatus() {
        return presenceStatus;
    }

    public void setPresenceStatus(String presenceStatus) {
        this.presenceStatus = presenceStatus;
    }

    @Override
    public String getType() {
        return EventNames.UPDATE_PRESENCE;
    }
}
