package voxeet.com.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;

import java.util.List;

import voxeet.com.sdk.models.OfferCandidate;
import voxeet.com.sdk.models.OfferDescription;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.START_SCREENSHARE)
public class StartScreenSharingResponse extends Event {

    @JsonProperty("candidates")
    private List<OfferCandidate> candidates;

    @JsonProperty("description")
    private OfferDescription description;

    @JsonProperty("user_id")
    private String userId;

    public StartScreenSharingResponse() {
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public List<OfferCandidate> getCandidates() {
        return candidates;
    }

    public void setCandidates(List<OfferCandidate> candidates) {
        this.candidates = candidates;
    }

    public OfferDescription getDescription() {
        return description;
    }

    public void setDescription(OfferDescription description) {
        this.description = description;
    }

    @Override
    public String getType() {
        return EventNames.START_VIDEO;
    }
}
