/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.services;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import voxeet.com.sdk.core.AbstractVoxeetService;
import voxeet.com.sdk.core.VoxeetSdkTemplate;
import voxeet.com.sdk.core.network.IUserRService;
import voxeet.com.sdk.core.preferences.VoxeetPreferences;
import voxeet.com.sdk.events.error.GetUploadTokenErrorEvent;
import voxeet.com.sdk.events.error.NewLoginRequiredEvent;
import voxeet.com.sdk.events.success.GetTokenUploadSuccessEvent;

public class UserService
extends AbstractVoxeetService<IUserRService> {
    public UserService(VoxeetSdkTemplate instance) {
        super(instance, IUserRService.class);
    }

    public final void getUploadToken() {
        Call<GetTokenUploadSuccessEvent> user = ((IUserRService)this.getService()).getUploadToken();
        user.enqueue((Callback)new Callback<GetTokenUploadSuccessEvent>(){

            public void onResponse(Call<GetTokenUploadSuccessEvent> call, Response<GetTokenUploadSuccessEvent> response) {
                if (response.isSuccessful()) {
                    UserService.this.getEventBus().post(response);
                    VoxeetPreferences.setUploadToken(((GetTokenUploadSuccessEvent)response.body()).getUploadToken());
                } else {
                    UserService.this.getEventBus().post((Object)new NewLoginRequiredEvent("New login required"));
                }
            }

            public void onFailure(Call<GetTokenUploadSuccessEvent> call, Throwable e) {
                UserService.this.getEventBus().post((Object)new GetUploadTokenErrorEvent(UserService.this.handleError(e)));
            }
        });
    }

    public static interface UserServiceListener {
        public void onLoginSuccess(String var1);

        public void onLogoutSucesss();
    }
}

