package voxeet.com.sdk.core.services;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import voxeet.com.sdk.core.VoxeetSdkTemplate;
import voxeet.com.sdk.core.network.IUserRService;
import voxeet.com.sdk.core.preferences.VoxeetPreferences;
import voxeet.com.sdk.events.error.GetUploadTokenErrorEvent;
import voxeet.com.sdk.events.error.NewLoginRequiredEvent;
import voxeet.com.sdk.events.success.GetTokenUploadSuccessEvent;

/**
 * Created by RomainB on 5/12/16.
 */
public class UserService extends voxeet.com.sdk.core.AbstractVoxeetService<IUserRService> {

    /**
     * Instantiates a new User service.
     *
     * @param instance the parent instance
     */
    public UserService(VoxeetSdkTemplate instance) {
        super(instance, IUserRService.class);
    }

    /**
     * The interface User service listener.
     */
    public interface UserServiceListener {
        /**
         * On login success.
         *
         * @param id the id
         */
        void onLoginSuccess(String id);

        /**
         * On logout sucesss.
         */
        void onLogoutSucesss();
    }


    /**
     * Gets upload token.
     */
    public final void getUploadToken() {
        final Call<GetTokenUploadSuccessEvent> user = getService().getUploadToken();
        user.enqueue(new Callback<GetTokenUploadSuccessEvent>() {
            @Override
            public void onResponse(Call<GetTokenUploadSuccessEvent> call, Response<GetTokenUploadSuccessEvent> response) {
                if(response.isSuccessful()) {
                    getEventBus().post(response);

                    VoxeetPreferences.setUploadToken(response.body().getUploadToken());
                } else {
                    getEventBus().post(new NewLoginRequiredEvent("New login required"));
                }
            }

            @Override
            public void onFailure(Call<GetTokenUploadSuccessEvent> call, Throwable e) {
                getEventBus().post(new GetUploadTokenErrorEvent(handleError(e)));
            }
        });
    }
}