/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.services;

import android.content.Context;
import android.media.AudioManager;
import android.support.annotation.NonNull;
import com.voxeet.android.media.MediaPowerManager;
import com.voxeet.android.media.audio.AudioRoute;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import voxeet.com.sdk.core.AbstractVoxeetService;
import voxeet.com.sdk.core.VoxeetSdkTemplate;
import voxeet.com.sdk.core.services.holder.ServiceProviderHolder;
import voxeet.com.sdk.events.success.ConferencePreJoinedEvent;
import voxeet.com.sdk.json.ConferenceDestroyedPush;
import voxeet.com.sdk.utils.Validate;

public class AudioService
extends AbstractVoxeetService {
    private final com.voxeet.android.media.audio.AudioManager mAudioManager;
    private final MediaPowerManager mMediaPowerManager;
    private final Context mContext;
    private final AudioManager mSystemAudioService;
    private int mSoundType = Integer.MIN_VALUE;

    public AudioService(@NonNull VoxeetSdkTemplate instance) {
        super(instance, ServiceProviderHolder.DEFAULT);
        this.mAudioManager = new com.voxeet.android.media.audio.AudioManager(instance.getApplicationContext());
        this.mMediaPowerManager = new MediaPowerManager(instance.getApplicationContext(), this.currentRoute());
        this.mContext = instance.getApplicationContext();
        instance.getEventBus().register((Object)this);
        this.mSystemAudioService = (AudioManager)this.mContext.getSystemService("audio");
    }

    @NonNull
    public List<AudioRoute> getAvailableRoutes() {
        return this.mAudioManager.availableRoutes();
    }

    public AudioRoute currentRoute() {
        return this.mAudioManager.outputRoute();
    }

    public boolean setAudioRoute(@NonNull AudioRoute route) {
        Validate.runningOnUiThread();
        this.mAudioManager.setOutputRoute(route);
        return true;
    }

    public void setSpeakerMode(boolean isSpeaker) {
        this.mAudioManager.setSpeakerMode(isSpeaker);
    }

    public boolean isSpeakerOn() {
        return AudioRoute.ROUTE_SPEAKER.equals((Object)this.mAudioManager.outputRoute());
    }

    public void acquireLocks() {
        this.mMediaPowerManager.acquire();
    }

    public void releaseLocks() {
        this.mMediaPowerManager.release();
    }

    public void setInVoiceCallSoundType() {
        this.mAudioManager.forceVolumeControlStream(0);
    }

    public void resetDefaultSoundType() {
        this.mAudioManager.forceVolumeControlStream(this.mAudioManager.getDefaultSoundStreamType());
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferencePreJoinedEvent event) {
        this.mSoundType = this.getUiSoundsStreamType();
        this.forceVolumeControlStream(0);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ConferenceDestroyedPush event) {
        if (Integer.MIN_VALUE != this.mSoundType) {
            this.forceVolumeControlStream(this.mSoundType);
        }
    }

    private int getUiSoundsStreamType() {
        try {
            Method method = this.mSystemAudioService.getClass().getDeclaredMethod("getUiSoundsStreamType", new Class[0]);
            Object result = method.invoke((Object)this.mSystemAudioService, new Object[0]);
            return (Integer)result;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return 1;
    }

    private void forceVolumeControlStream(int type) {
        try {
            Method method = this.mSystemAudioService.getClass().getDeclaredMethod("forceVolumeControlStream", Integer.TYPE);
            method.invoke((Object)this.mSystemAudioService, type);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

