package voxeet.com.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;

import java.util.HashMap;
import java.util.Map;

/**
 * Note : this class is parsed by Gson due to an issue with Jackson with
 * HashMap : String -> HashMap : String -> Infos
 */

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.CONFERENCE_STATS)
public class ConferenceStats extends Event {
    private String conference_id;

    private Map<String, Map<String, Infos>> participantStats;

    public String getConference_id() {
        return conference_id;
    }

    public float getScore(String userId) {
        float score = 0;
        if (participantStats.containsKey(userId)) {
            Map<String, Infos> map = participantStats.get(userId);
            if (null != map && map.containsKey(userId)) {
                Infos infos = map.get(userId);
                if (null != infos) {
                    for (Stats stats : infos.stats)
                        score += stats.score;
                    score /= Math.max(1, infos.stats.length);
                }
            }
        }
        return score;
    }

    @Override
    public String getType() {
        return EventNames.CONFERENCE_STATS;
    }

    public class Infos {
        public Stats[] stats;
    }

    public class Stats {
        float score;

    }
}
