package voxeet.com.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;

import java.util.List;

/**
 * Created by Thomas on 20/10/2015.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.FILE_PRESENTATION_START)
public class FilePresentationStart extends Event {

    private String title;

    private String ownerId;

    private List<String> images;

    private List<String> thumbnails;

    private int position = 0;

    public FilePresentationStart() {

    }

    public FilePresentationStart(String fileName, String ownerId, List<String> images, List<String> thumbnails) {
        this.title = fileName;
        this.ownerId = ownerId;
        this.images = images;
        this.thumbnails = thumbnails;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public List<String> getImages() {
        return images;
    }

    public void setImages(List<String> images) {
        this.images = images;
    }

    public int getPosition() {
        return position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public List<String> getThumbnails() {
        return thumbnails;
    }

    public void setThumbnails(List<String> thumbnails) {
        this.thumbnails = thumbnails;
    }

    @Override
    public String getType() {
        return EventNames.FILE_PRESENTATION_START;
    }
}
