/*
 * Decompiled with CFR 0.152.
 */
package voxeet.com.sdk.core.services;

import android.support.annotation.NonNull;
import com.voxeet.android.media.MediaPowerManager;
import com.voxeet.android.media.audio.AudioManager;
import com.voxeet.android.media.audio.AudioRoute;
import java.util.List;
import voxeet.com.sdk.core.AbstractVoxeetService;
import voxeet.com.sdk.core.VoxeetSdkTemplate;
import voxeet.com.sdk.core.services.holder.ServiceProviderHolder;
import voxeet.com.sdk.utils.Validate;

public class AudioService
extends AbstractVoxeetService {
    private final AudioManager mAudioManager;
    private final MediaPowerManager mMediaPowerManager;

    public AudioService(@NonNull VoxeetSdkTemplate instance) {
        super(instance, ServiceProviderHolder.DEFAULT);
        this.mAudioManager = new AudioManager(instance.getApplicationContext());
        this.mMediaPowerManager = new MediaPowerManager(instance.getApplicationContext(), this.currentRoute());
    }

    @NonNull
    public List<AudioRoute> getAvailableRoutes() {
        return this.mAudioManager.availableRoutes();
    }

    public AudioRoute currentRoute() {
        return this.mAudioManager.outputRoute();
    }

    public boolean setAudioRoute(@NonNull AudioRoute route) {
        Validate.runningOnUiThread();
        this.mAudioManager.setOutputRoute(route);
        return true;
    }

    public void setSpeakerMode(boolean isSpeaker) {
        this.mAudioManager.setSpeakerMode(isSpeaker);
    }

    public boolean isSpeakerOn() {
        return AudioRoute.ROUTE_SPEAKER.equals((Object)this.mAudioManager.outputRoute());
    }

    public void acquireLocks() {
        this.mMediaPowerManager.acquire();
    }

    public void releaseLocks() {
        this.mMediaPowerManager.release();
    }
}

