package voxeet.com.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;

import voxeet.com.sdk.core.preferences.VoxeetPreferences;

/**
 * Created by Thomas on 20/10/2015.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.FILE_PRESENTATION_UPDATED)
public class FilePresentationUpdated extends Event {

    private String conferenceId;

    private String userId;

    private String fileId;

    private int position;

    public FilePresentationUpdated() {

    }

    public FilePresentationUpdated(String conferenceId,
                                   String userId,
                                   int imageCount,
                                   String fileId,
                                   int position) {
        this();

        setConferenceId(conferenceId)
                .setUserId(userId)
                .setFileId(fileId)
                .setPosition(position);
    }

    public String getConferenceId() {
        return conferenceId;
    }

    public FilePresentationUpdated setConferenceId(String conferenceId) {
        this.conferenceId = conferenceId;
        return this;
    }

    public String getFileId() {
        return fileId;
    }

    public FilePresentationUpdated setFileId(String fileId) {
        this.fileId = fileId;
        return this;
    }

    public String setUserId() {
        return userId;
    }

    public FilePresentationUpdated setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public int getPosition() {
        return position;
    }

    public FilePresentationUpdated setPosition(int position) {
        this.position = position;
        return this;
    }

    @Override
    public String getType() {
        return EventNames.FILE_PRESENTATION_UPDATED;
    }
}
